/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.MapConfig;
import org.apache.samza.runtime.UUIDGenerator;

public class ApplicationConfig
extends MapConfig {
    @Deprecated
    public static final String PROCESSOR_ID = "processor.id";
    public static final String APP_PROCESSOR_ID_GENERATOR_CLASS = "app.processor-id-generator.class";
    public static final String APP_NAME = "app.name";
    public static final String APP_ID = "app.id";
    public static final String APP_CLASS = "app.class";
    public static final String APP_MODE = "app.mode";
    public static final String APP_RUN_ID = "app.run.id";

    public ApplicationConfig(Config config) {
        super((Map)config);
    }

    public String getAppProcessorIdGeneratorClass() {
        return this.get(APP_PROCESSOR_ID_GENERATOR_CLASS, UUIDGenerator.class.getName());
    }

    public String getAppName() {
        return this.get(APP_NAME, this.get(JobConfig.JOB_NAME()));
    }

    public String getAppId() {
        return this.get(APP_ID, this.get(JobConfig.JOB_ID(), "1"));
    }

    public String getAppClass() {
        return this.get(APP_CLASS, null);
    }

    public String getGlobalAppId() {
        return String.format("app-%s-%s", this.getAppName(), this.getAppId());
    }

    @Deprecated
    public String getProcessorId() {
        return this.get(PROCESSOR_ID, null);
    }

    public String getRunId() {
        return this.get(APP_RUN_ID, null);
    }

    public ApplicationMode getAppMode() {
        return ApplicationMode.valueOf(this.get(APP_MODE, ApplicationMode.STREAM.name()).toUpperCase());
    }

    public static enum ApplicationMode {
        STREAM,
        BATCH;

    }
}

