/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.clustermanager;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaResourceRequest
implements Comparable<SamzaResourceRequest> {
    private static final Logger log = LoggerFactory.getLogger(SamzaResourceRequest.class);
    private final int numCores;
    private final int memoryMB;
    private final String preferredHost;
    private final String requestID;
    private final String containerID;
    private final long requestTimestampMs;

    public SamzaResourceRequest(int numCores, int memoryMB, String preferredHost, String expectedContainerID) {
        this.numCores = numCores;
        this.memoryMB = memoryMB;
        this.preferredHost = preferredHost;
        this.requestID = UUID.randomUUID().toString();
        this.containerID = expectedContainerID;
        this.requestTimestampMs = System.currentTimeMillis();
        log.info("Resource Request created for {} on {} at {}", new Object[]{this.containerID, this.preferredHost, this.requestTimestampMs});
    }

    public String getContainerID() {
        return this.containerID;
    }

    public long getRequestTimestampMs() {
        return this.requestTimestampMs;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public int getNumCores() {
        return this.numCores;
    }

    public String getPreferredHost() {
        return this.preferredHost;
    }

    public int getMemoryMB() {
        return this.memoryMB;
    }

    public String toString() {
        return "SamzaResourceRequest{numCores=" + this.numCores + ", memoryMB=" + this.memoryMB + ", preferredHost='" + this.preferredHost + '\'' + ", requestID='" + this.requestID + '\'' + ", containerID=" + this.containerID + ", requestTimestampMs=" + this.requestTimestampMs + '}';
    }

    @Override
    public int compareTo(SamzaResourceRequest o) {
        if (this.requestTimestampMs < o.requestTimestampMs) {
            return -1;
        }
        if (this.requestTimestampMs > o.requestTimestampMs) {
            return 1;
        }
        return 0;
    }
}

