/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.clustermanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.samza.clustermanager.ClusterResourceManager;
import org.apache.samza.clustermanager.SamzaResource;
import org.apache.samza.clustermanager.SamzaResourceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRequestState {
    private static final Logger log = LoggerFactory.getLogger(ResourceRequestState.class);
    public static final String ANY_HOST = "ANY_HOST";
    private final Map<String, List<SamzaResource>> allocatedResources = new HashMap<String, List<SamzaResource>>();
    private final PriorityQueue<SamzaResourceRequest> requestsQueue = new PriorityQueue();
    private final Map<String, AtomicInteger> requestsToCountMap = new HashMap<String, AtomicInteger>();
    private final boolean hostAffinityEnabled;
    private final ClusterResourceManager manager;
    private final Object lock = new Object();

    public ResourceRequestState(boolean hostAffinityEnabled, ClusterResourceManager manager) {
        this.hostAffinityEnabled = hostAffinityEnabled;
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceRequest(SamzaResourceRequest request) {
        Object object = this.lock;
        synchronized (object) {
            this.requestsQueue.add(request);
            String preferredHost = request.getPreferredHost();
            if (this.hostAffinityEnabled) {
                if (this.requestsToCountMap.containsKey(preferredHost)) {
                    this.requestsToCountMap.get(preferredHost).incrementAndGet();
                } else {
                    this.requestsToCountMap.put(preferredHost, new AtomicInteger(1));
                }
                if (!this.allocatedResources.containsKey(preferredHost)) {
                    this.allocatedResources.put(preferredHost, new ArrayList());
                }
            }
            this.manager.requestResources(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelResourceRequest(SamzaResourceRequest request) {
        log.info("Canceling resource request on {} for {}", (Object)request.getPreferredHost(), (Object)request.getContainerID());
        Object object = this.lock;
        synchronized (object) {
            this.requestsQueue.remove(request);
            if (this.hostAffinityEnabled) {
                this.requestsToCountMap.get(request.getPreferredHost()).decrementAndGet();
            }
            this.manager.cancelResourceRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(SamzaResource samzaResource) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hostAffinityEnabled) {
                String hostName = samzaResource.getHost();
                AtomicInteger requestCount = this.requestsToCountMap.get(hostName);
                if (requestCount == null || requestCount.get() == 0) {
                    log.info(" This host was not requested. {} saving the samzaResource {} in the buffer for ANY_HOST", (Object)hostName, (Object)samzaResource.getResourceID());
                    this.addToAllocatedResourceList(ANY_HOST, samzaResource);
                } else {
                    int requestCountOnThisHost = requestCount.get();
                    List<SamzaResource> allocatedResourcesOnThisHost = this.allocatedResources.get(hostName);
                    if (requestCountOnThisHost > 0) {
                        if (allocatedResourcesOnThisHost == null || allocatedResourcesOnThisHost.size() < requestCountOnThisHost) {
                            log.info("Got matched samzaResource {} in the buffer for preferredHost: {}", (Object)samzaResource.getResourceID(), (Object)hostName);
                            this.addToAllocatedResourceList(hostName, samzaResource);
                        } else {
                            log.info("The number of containers already allocated on {} is greater than what was requested, which is {}. Hence, saving the samzaResource {} in the buffer for ANY_HOST", new Object[]{hostName, requestCountOnThisHost, samzaResource.getResourceID()});
                            this.addToAllocatedResourceList(ANY_HOST, samzaResource);
                        }
                    }
                }
            } else {
                log.info("Host affinity not enabled. Saving the samzaResource {} in the buffer for ANY_HOST", (Object)samzaResource.getResourceID());
                this.addToAllocatedResourceList(ANY_HOST, samzaResource);
            }
        }
    }

    private void addToAllocatedResourceList(String host, SamzaResource samzaResource) {
        List<SamzaResource> samzaResources = this.allocatedResources.get(host);
        if (samzaResources != null) {
            samzaResources.add(samzaResource);
        } else {
            samzaResources = new ArrayList<SamzaResource>();
            samzaResources.add(samzaResource);
            this.allocatedResources.put(host, samzaResources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStateAfterAssignment(SamzaResourceRequest request, String assignedHost, SamzaResource samzaResource) {
        Object object = this.lock;
        synchronized (object) {
            this.requestsQueue.remove(request);
            if (this.allocatedResources.get(assignedHost) != null) {
                this.allocatedResources.get(assignedHost).remove(samzaResource);
            }
            if (this.allocatedResources.get(ANY_HOST) != null) {
                this.allocatedResources.get(ANY_HOST).remove(samzaResource);
            }
            if (this.hostAffinityEnabled) {
                this.requestsToCountMap.get(request.getPreferredHost()).decrementAndGet();
            }
            this.manager.cancelResourceRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int releaseExtraResources() {
        Object object = this.lock;
        synchronized (object) {
            int numReleasedResources = 0;
            if (this.requestsQueue.isEmpty()) {
                log.debug("Resource Requests Queue is empty.");
                if (this.hostAffinityEnabled) {
                    List<String> allocatedHosts = this.getAllocatedHosts();
                    for (String host : allocatedHosts) {
                        numReleasedResources += this.releaseResourcesForHost(host);
                    }
                } else {
                    numReleasedResources += this.releaseResourcesForHost(ANY_HOST);
                }
                this.clearState();
            }
            return numReleasedResources;
        }
    }

    public void releaseUnstartableContainer(SamzaResource resource) {
        log.info("Releasing unstartable container {}", (Object)resource.getResourceID());
        this.manager.releaseResources(resource);
    }

    private int releaseResourcesForHost(String host) {
        int numReleasedResources = 0;
        List<SamzaResource> samzaResources = this.allocatedResources.get(host);
        if (samzaResources != null) {
            for (SamzaResource resource : samzaResources) {
                log.info("Releasing extra resource {} allocated on {}", (Object)resource.getResourceID(), (Object)host);
                this.manager.releaseResources(resource);
                ++numReleasedResources;
            }
        }
        return numReleasedResources;
    }

    private void clearState() {
        this.allocatedResources.clear();
        this.requestsToCountMap.clear();
        this.requestsQueue.clear();
    }

    private List<String> getAllocatedHosts() {
        ArrayList<String> hostKeys = new ArrayList<String>();
        for (Map.Entry<String, List<SamzaResource>> entry : this.allocatedResources.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            hostKeys.add(entry.getKey());
        }
        return hostKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SamzaResource peekResource(String host) {
        Object object = this.lock;
        synchronized (object) {
            List<SamzaResource> resourcesOnPreferredHostBuffer = this.allocatedResources.get(host);
            List<SamzaResource> resourcesOnAnyHostBuffer = this.allocatedResources.get(ANY_HOST);
            if (resourcesOnPreferredHostBuffer != null && !resourcesOnPreferredHostBuffer.isEmpty()) {
                SamzaResource resource = resourcesOnPreferredHostBuffer.get(0);
                log.info("Returning a buffered resource: {} for {} from preferred-host buffer.", (Object)resource.getResourceID(), (Object)host);
                return resource;
            }
            if (resourcesOnAnyHostBuffer != null && !resourcesOnAnyHostBuffer.isEmpty()) {
                log.debug("No resources on preferred-host buffer. Scanning ANY_HOST buffer");
                SamzaResource resource = resourcesOnAnyHostBuffer.stream().filter(resrc -> resrc.getHost().equals(host)).findAny().orElse(null);
                if (resource != null) {
                    log.info("Returning a buffered resource: {} for {} from ANY_HOST buffer.", (Object)resource.getResourceID(), (Object)host);
                }
                return resource;
            }
            log.debug("Cannot find any resource in the ANY_HOST buffer for {} because both buffers are empty", (Object)host);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SamzaResourceRequest peekPendingRequest() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestsQueue.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numPendingRequests() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestsQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SamzaResource> getResourcesOnAHost(String host) {
        Object object = this.lock;
        synchronized (object) {
            List<SamzaResource> samzaResourceList = this.allocatedResources.get(host);
            if (samzaResourceList == null) {
                return null;
            }
            return new ArrayList<SamzaResource>(samzaResourceList);
        }
    }

    Map<String, AtomicInteger> getRequestsToCountMap() {
        return Collections.unmodifiableMap(this.requestsToCountMap);
    }
}

