/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.clustermanager;

import org.apache.samza.clustermanager.AbstractContainerAllocator;
import org.apache.samza.clustermanager.ClusterResourceManager;
import org.apache.samza.clustermanager.ResourceRequestState;
import org.apache.samza.clustermanager.SamzaApplicationState;
import org.apache.samza.clustermanager.SamzaResourceRequest;
import org.apache.samza.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostAwareContainerAllocator
extends AbstractContainerAllocator {
    private static final Logger log = LoggerFactory.getLogger(HostAwareContainerAllocator.class);
    private final int requestTimeout;

    public HostAwareContainerAllocator(ClusterResourceManager manager, int timeout, Config config, SamzaApplicationState state) {
        super(manager, new ResourceRequestState(true, manager), config, state);
        this.requestTimeout = timeout;
    }

    @Override
    public void assignResourceRequests() {
        while (this.hasPendingRequest()) {
            SamzaResourceRequest request = this.peekPendingRequest();
            log.info("Handling request: " + request.getContainerID() + " " + request.getRequestTimestampMs() + " " + request.getPreferredHost());
            String preferredHost = request.getPreferredHost();
            String containerID = request.getContainerID();
            if (this.hasAllocatedResource(preferredHost)) {
                log.info("Found a matched-container {} on the preferred host. Running on {}", (Object)containerID, (Object)preferredHost);
                this.runStreamProcessor(request, preferredHost);
                this.state.matchedResourceRequests.incrementAndGet();
                continue;
            }
            log.info("Did not find any allocated resources on preferred host {} for running container id {}", (Object)preferredHost, (Object)containerID);
            boolean expired = this.requestExpired(request);
            boolean resourceAvailableOnAnyHost = this.hasAllocatedResource("ANY_HOST");
            if (expired) {
                this.updateExpiryMetrics(request);
                if (resourceAvailableOnAnyHost) {
                    log.info("Request for container: {} on {} has expired. Running on ANY_HOST", (Object)request.getContainerID(), (Object)request.getPreferredHost());
                    this.runStreamProcessor(request, "ANY_HOST");
                    continue;
                }
                log.info("Request for container: {} on {} has expired. Requesting additional resources on ANY_HOST.", (Object)request.getContainerID(), (Object)request.getPreferredHost());
                this.resourceRequestState.cancelResourceRequest(request);
                this.requestResource(containerID, "ANY_HOST");
                continue;
            }
            log.info("Request for container: {} on {} has not yet expired. Request creation time: {}. Request timeout: {}", new Object[]{request.getContainerID(), request.getPreferredHost(), request.getRequestTimestampMs(), this.requestTimeout});
            break;
        }
    }

    private boolean requestExpired(SamzaResourceRequest request) {
        boolean requestExpired;
        long currTime = System.currentTimeMillis();
        boolean bl = requestExpired = currTime - request.getRequestTimestampMs() > (long)this.requestTimeout;
        if (requestExpired) {
            log.info("Request {} with currTime {} has expired", (Object)request, (Object)currTime);
        }
        return requestExpired;
    }

    private void updateExpiryMetrics(SamzaResourceRequest request) {
        String preferredHost = request.getPreferredHost();
        if ("ANY_HOST".equals(preferredHost)) {
            this.state.expiredAnyHostRequests.incrementAndGet();
        } else {
            this.state.expiredPreferredHostRequests.incrementAndGet();
        }
    }
}

