/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.clustermanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.samza.PartitionChangeException;
import org.apache.samza.SamzaException;
import org.apache.samza.checkpoint.CheckpointManager;
import org.apache.samza.clustermanager.ContainerProcessManager;
import org.apache.samza.clustermanager.SamzaApplicationState;
import org.apache.samza.config.ClusterManagerConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.ShellCommandConfig;
import org.apache.samza.config.StorageConfig;
import org.apache.samza.config.TaskConfigJava;
import org.apache.samza.container.TaskName;
import org.apache.samza.coordinator.JobModelManager;
import org.apache.samza.coordinator.StreamPartitionCountMonitor;
import org.apache.samza.coordinator.stream.CoordinatorStreamManager;
import org.apache.samza.job.model.ContainerModel;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.job.model.TaskModel;
import org.apache.samza.metrics.JmxServer;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.serializers.model.SamzaObjectMapper;
import org.apache.samza.storage.ChangelogStreamManager;
import org.apache.samza.system.StreamMetadataCache;
import org.apache.samza.system.SystemAdmins;
import org.apache.samza.system.SystemStream;
import org.apache.samza.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterBasedJobCoordinator {
    private static final Logger log = LoggerFactory.getLogger(ClusterBasedJobCoordinator.class);
    private final Config config;
    private final ClusterManagerConfig clusterManagerConfig;
    private final SamzaApplicationState state;
    private final ContainerProcessManager containerProcessManager;
    private final JobModelManager jobModelManager;
    private final ChangelogStreamManager changelogStreamManager;
    private final CoordinatorStreamManager coordinatorStreamManager;
    private final long jobCoordinatorSleepInterval;
    private final boolean isJmxEnabled;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final boolean hasDurableStores;
    private final StreamPartitionCountMonitor partitionMonitor;
    private final MetricsRegistryMap metrics = new MetricsRegistryMap();
    private JmxServer jmxServer;
    private volatile Exception coordinatorException = null;
    private SystemAdmins systemAdmins = null;

    public ClusterBasedJobCoordinator(Config coordinatorSystemConfig) {
        this.coordinatorStreamManager = new CoordinatorStreamManager(coordinatorSystemConfig, (MetricsRegistry)this.metrics);
        this.coordinatorStreamManager.register(this.getClass().getSimpleName());
        this.coordinatorStreamManager.start();
        this.coordinatorStreamManager.bootstrap();
        this.changelogStreamManager = new ChangelogStreamManager(this.coordinatorStreamManager);
        this.jobModelManager = JobModelManager.apply(this.coordinatorStreamManager.getConfig(), this.changelogStreamManager.readPartitionMapping());
        this.config = this.jobModelManager.jobModel().getConfig();
        this.hasDurableStores = new StorageConfig(this.config).hasDurableStores();
        this.state = new SamzaApplicationState(this.jobModelManager);
        this.systemAdmins = new SystemAdmins(this.config);
        this.partitionMonitor = this.getPartitionCountMonitor(this.config, this.systemAdmins);
        this.clusterManagerConfig = new ClusterManagerConfig(this.config);
        this.isJmxEnabled = this.clusterManagerConfig.getJmxEnabledOnJobCoordinator();
        this.jobCoordinatorSleepInterval = this.clusterManagerConfig.getJobCoordinatorSleepInterval();
        this.containerProcessManager = new ContainerProcessManager(this.config, this.state, this.metrics);
    }

    public void run() {
        if (!this.isStarted.compareAndSet(false, true)) {
            log.info("Attempting to start an already started job coordinator. ");
            return;
        }
        if (this.isJmxEnabled) {
            this.jmxServer = new JmxServer();
            this.state.jmxUrl = this.jmxServer.getJmxUrl();
            this.state.jmxTunnelingUrl = this.jmxServer.getTunnelingJmxUrl();
        } else {
            this.jmxServer = null;
        }
        try {
            log.info("Starting Cluster Based Job Coordinator");
            JobModel jobModel = this.jobModelManager.jobModel();
            CheckpointManager checkpointManager = new TaskConfigJava(this.config).getCheckpointManager((MetricsRegistry)this.metrics);
            if (checkpointManager != null) {
                checkpointManager.createResources();
            }
            ChangelogStreamManager.createChangelogStreams(jobModel.getConfig(), jobModel.maxChangeLogStreamPartitions);
            Map<TaskName, Integer> prevPartitionMappings = this.changelogStreamManager.readPartitionMapping();
            HashMap<TaskName, Integer> taskPartitionMappings = new HashMap<TaskName, Integer>();
            Map<String, ContainerModel> containers = jobModel.getContainers();
            for (ContainerModel containerModel : containers.values()) {
                for (TaskModel taskModel : containerModel.getTasks().values()) {
                    taskPartitionMappings.put(taskModel.getTaskName(), taskModel.getChangelogPartition().getPartitionId());
                }
            }
            this.changelogStreamManager.updatePartitionMapping(prevPartitionMappings, taskPartitionMappings);
            this.containerProcessManager.start();
            this.systemAdmins.start();
            this.partitionMonitor.start();
            boolean isInterrupted = false;
            while (!(this.containerProcessManager.shouldShutdown() || this.checkAndThrowException() || isInterrupted)) {
                try {
                    Thread.sleep(this.jobCoordinatorSleepInterval);
                }
                catch (InterruptedException e) {
                    isInterrupted = true;
                    log.error("Interrupted in job coordinator loop {} ", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Throwable e) {
            log.error("Exception thrown in the JobCoordinator loop {} ", e);
            throw new SamzaException(e);
        }
        finally {
            this.onShutDown();
        }
    }

    private boolean checkAndThrowException() throws Exception {
        if (this.coordinatorException != null) {
            throw this.coordinatorException;
        }
        return false;
    }

    private void onShutDown() {
        try {
            this.partitionMonitor.stop();
            this.systemAdmins.stop();
            this.containerProcessManager.stop();
            this.coordinatorStreamManager.stop();
        }
        catch (Throwable e) {
            log.error("Exception while stopping task manager {}", e);
        }
        log.info("Stopped task manager");
        if (this.jmxServer != null) {
            try {
                this.jmxServer.stop();
                log.info("Stopped Jmx Server");
            }
            catch (Throwable e) {
                log.error("Exception while stopping jmx server {}", e);
            }
        }
    }

    private StreamPartitionCountMonitor getPartitionCountMonitor(Config config, SystemAdmins systemAdmins) {
        StreamMetadataCache streamMetadata = new StreamMetadataCache(systemAdmins, 0, SystemClock.instance());
        Set<SystemStream> inputStreamsToMonitor = new TaskConfigJava(config).getAllInputStreams();
        if (inputStreamsToMonitor.isEmpty()) {
            throw new SamzaException("Input streams to a job can not be empty.");
        }
        return new StreamPartitionCountMonitor(inputStreamsToMonitor, streamMetadata, (MetricsRegistry)this.metrics, new JobConfig(config).getMonitorPartitionChangeFrequency(), streamsChanged -> {
            if (this.hasDurableStores) {
                log.error("Input topic partition count changed in a job with durable state. Failing the job.");
                this.state.status = SamzaApplicationState.SamzaAppStatus.FAILED;
            }
            this.coordinatorException = new PartitionChangeException("Input topic partition count changes detected.");
        });
    }

    @VisibleForTesting
    SamzaApplicationState.SamzaAppStatus getAppStatus() {
        SamzaApplicationState.SamzaAppStatus copy = this.state.status;
        return copy;
    }

    @VisibleForTesting
    StreamPartitionCountMonitor getPartitionMonitor() {
        return this.partitionMonitor;
    }

    public static void main(String[] args) {
        MapConfig coordinatorSystemConfig = null;
        String coordinatorSystemEnv = System.getenv(ShellCommandConfig.ENV_COORDINATOR_SYSTEM_CONFIG());
        try {
            log.info("Parsing coordinator system config {}", (Object)coordinatorSystemEnv);
            coordinatorSystemConfig = new MapConfig((Map)SamzaObjectMapper.getObjectMapper().readValue(coordinatorSystemEnv, Config.class));
        }
        catch (IOException e) {
            log.error("Exception while reading coordinator stream config {}", (Throwable)e);
            throw new SamzaException((Throwable)e);
        }
        ClusterBasedJobCoordinator jc = new ClusterBasedJobCoordinator((Config)coordinatorSystemConfig);
        jc.run();
    }
}

