/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.clustermanager;

import java.util.Map;
import org.apache.samza.SamzaException;
import org.apache.samza.clustermanager.ClusterResourceManager;
import org.apache.samza.clustermanager.ResourceRequestState;
import org.apache.samza.clustermanager.SamzaApplicationState;
import org.apache.samza.clustermanager.SamzaResource;
import org.apache.samza.clustermanager.SamzaResourceRequest;
import org.apache.samza.config.ClusterManagerConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.TaskConfig;
import org.apache.samza.job.CommandBuilder;
import org.apache.samza.job.ShellCommandBuilder;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContainerAllocator
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AbstractContainerAllocator.class);
    private volatile boolean isRunning = true;
    private final TaskConfig taskConfig;
    private final Config config;
    protected final ClusterResourceManager clusterResourceManager;
    protected final int allocatorSleepIntervalMs;
    protected final int containerMemoryMb;
    protected final int containerNumCpuCores;
    protected final SamzaApplicationState state;
    protected final ResourceRequestState resourceRequestState;

    public AbstractContainerAllocator(ClusterResourceManager containerProcessManager, ResourceRequestState resourceRequestState, Config config, SamzaApplicationState state) {
        ClusterManagerConfig clusterManagerConfig = new ClusterManagerConfig(config);
        this.clusterResourceManager = containerProcessManager;
        this.allocatorSleepIntervalMs = clusterManagerConfig.getAllocatorSleepTime();
        this.resourceRequestState = resourceRequestState;
        this.containerMemoryMb = clusterManagerConfig.getContainerMemoryMb();
        this.containerNumCpuCores = clusterManagerConfig.getNumCores();
        this.taskConfig = new TaskConfig(config);
        this.state = state;
        this.config = config;
    }

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                this.assignResourceRequests();
                this.resourceRequestState.releaseExtraResources();
                Thread.sleep(this.allocatorSleepIntervalMs);
            }
            catch (InterruptedException e) {
                log.warn("Got InterruptedException in AllocatorThread.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.error("Got unknown Exception in AllocatorThread.", (Throwable)e);
            }
        }
    }

    protected abstract void assignResourceRequests();

    protected void runStreamProcessor(SamzaResourceRequest request, String preferredHost) {
        CommandBuilder builder = this.getCommandBuilder(request.getContainerID());
        SamzaResource resource = this.peekAllocatedResource(preferredHost);
        if (resource == null) {
            throw new SamzaException("Expected resource was unavailable on host " + preferredHost);
        }
        this.resourceRequestState.updateStateAfterAssignment(request, preferredHost, resource);
        String containerID = request.getContainerID();
        log.info("Found available resources on {}. Assigning request for container_id {} with timestamp {} to resource {}", new Object[]{preferredHost, String.valueOf(containerID), request.getRequestTimestampMs(), resource.getResourceID()});
        this.clusterResourceManager.launchStreamProcessor(resource, builder);
        this.state.pendingContainers.put(containerID, resource);
    }

    public void requestResources(Map<String, String> resourceToHostMappings) {
        for (Map.Entry<String, String> entry : resourceToHostMappings.entrySet()) {
            String containerId = entry.getKey();
            String preferredHost = entry.getValue();
            if (preferredHost == null) {
                preferredHost = "ANY_HOST";
            }
            this.requestResource(containerId, preferredHost);
        }
    }

    protected final boolean hasPendingRequest() {
        return this.peekPendingRequest() != null;
    }

    protected final SamzaResourceRequest peekPendingRequest() {
        return this.resourceRequestState.peekPendingRequest();
    }

    public final void requestResource(String containerID, String preferredHost) {
        SamzaResourceRequest request = new SamzaResourceRequest(this.containerNumCpuCores, this.containerMemoryMb, preferredHost, containerID);
        this.resourceRequestState.addResourceRequest(request);
        this.state.containerRequests.incrementAndGet();
        if ("ANY_HOST".equals(preferredHost)) {
            this.state.anyHostRequests.incrementAndGet();
        } else {
            this.state.preferredHostRequests.incrementAndGet();
        }
    }

    protected boolean hasAllocatedResource(String host) {
        return this.peekAllocatedResource(host) != null;
    }

    protected SamzaResource peekAllocatedResource(String host) {
        return this.resourceRequestState.peekResource(host);
    }

    private CommandBuilder getCommandBuilder(String samzaContainerId) {
        String cmdBuilderClassName = this.taskConfig.getCommandClass(ShellCommandBuilder.class.getName());
        CommandBuilder cmdBuilder = Util.getObj(cmdBuilderClassName, CommandBuilder.class);
        cmdBuilder.setConfig(this.config).setId(samzaContainerId).setUrl(this.state.jobModelManager.server().getUrl());
        return cmdBuilder;
    }

    public final void addResource(SamzaResource samzaResource) {
        this.resourceRequestState.addResource(samzaResource);
    }

    public void stop() {
        this.isRunning = false;
    }
}

