/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.checkpoint.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import org.apache.samza.SamzaException;
import org.apache.samza.checkpoint.Checkpoint;
import org.apache.samza.checkpoint.CheckpointManager;
import org.apache.samza.checkpoint.file.FileSystemCheckpointManager$;
import org.apache.samza.container.TaskName;
import org.apache.samza.serializers.CheckpointSerde;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u001b\tYb)\u001b7f'f\u001cH/Z7DQ\u0016\u001c7\u000e]8j]Rl\u0015M\\1hKJT!a\u0001\u0003\u0002\t\u0019LG.\u001a\u0006\u0003\u000b\u0019\t!b\u00195fG.\u0004x.\u001b8u\u0015\t9\u0001\"A\u0003tC6T\u0018M\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u000191\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!!E\"iK\u000e\\\u0007o\\5oi6\u000bg.Y4fe\"A1\u0004\u0001B\u0001B\u0003%A$A\u0004k_\nt\u0015-\\3\u0011\u0005u\u0019cB\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\u0012A\u0002)sK\u0012,g-\u0003\u0002%K\t11\u000b\u001e:j]\u001eT!AI\u0010\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\nAA]8piB\u0011\u0011\u0006L\u0007\u0002U)\u00111FE\u0001\u0003S>L!!\f\u0016\u0003\t\u0019KG.\u001a\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005)1/\u001a:eKB\u0011\u0011\u0007N\u0007\u0002e)\u00111GB\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u00148/\u0003\u00026e\ty1\t[3dWB|\u0017N\u001c;TKJ$W\rC\u00038\u0001\u0011\u0005\u0001(\u0001\u0004=S:LGO\u0010\u000b\u0005smbT\b\u0005\u0002;\u00015\t!\u0001C\u0003\u001cm\u0001\u0007A\u0004C\u0003(m\u0001\u0007\u0001\u0006C\u00040mA\u0005\t\u0019\u0001\u0019\t\u000b}\u0002A\u0011\t!\u0002\u0011I,w-[:uKJ$\"!\u0011#\u0011\u0005y\u0011\u0015BA\" \u0005\u0011)f.\u001b;\t\u000b\u0015s\u0004\u0019\u0001$\u0002\u0011Q\f7o\u001b(b[\u0016\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u0004\u0002\u0013\r|g\u000e^1j]\u0016\u0014\u0018BA&I\u0005!!\u0016m]6OC6,\u0007\"B'\u0001\t\u0003q\u0015!E4fi\u000eCWmY6q_&tGOR5mKR\u0011\u0001f\u0014\u0005\u0006\u000b2\u0003\rA\u0012\u0005\u0006#\u0002!\tAU\u0001\u0010oJLG/Z\"iK\u000e\\\u0007o\\5oiR\u0019\u0011i\u0015+\t\u000b\u0015\u0003\u0006\u0019\u0001$\t\u000b\u0015\u0001\u0006\u0019A+\u0011\u0005]1\u0016BA,\u0005\u0005)\u0019\u0005.Z2la>Lg\u000e\u001e\u0005\u00063\u0002!\tAW\u0001\u0013e\u0016\fG\rT1ti\u000eCWmY6q_&tG\u000f\u0006\u0002V7\")Q\t\u0017a\u0001\r\")Q\f\u0001C\u0001=\u0006)1\u000f^1siR\t\u0011\tC\u0003a\u0001\u0011\u0005a,\u0001\u0003ti>\u0004\b\"\u00022\u0001\t\u0013\u0019\u0017aB4fi\u001aKG.\u001a\u000b\u0005Q\u0011,g\rC\u0003\u001cC\u0002\u0007A\u0004C\u0003FC\u0002\u0007a\tC\u0003hC\u0002\u0007A$\u0001\u0005gS2,G+\u001f9f\u000f\u001dI'!!A\t\u0002)\f1DR5mKNK8\u000f^3n\u0007\",7m\u001b9pS:$X*\u00198bO\u0016\u0014\bC\u0001\u001el\r\u001d\t!!!A\t\u00021\u001c\"a[7\u0011\u0005yq\u0017BA8 \u0005\u0019\te.\u001f*fM\")qg\u001bC\u0001cR\t!\u000eC\u0004tWF\u0005I\u0011\u0001;\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0005)(F\u0001\u0019wW\u00059\bC\u0001=~\u001b\u0005I(B\u0001>|\u0003%)hn\u00195fG.,GM\u0003\u0002}?\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005yL(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class FileSystemCheckpointManager
implements CheckpointManager {
    private final String jobName;
    private final File root;
    private final CheckpointSerde serde;

    public static CheckpointSerde $lessinit$greater$default$3() {
        return FileSystemCheckpointManager$.MODULE$.$lessinit$greater$default$3();
    }

    public void register(TaskName taskName) {
    }

    public File getCheckpointFile(TaskName taskName) {
        return this.getFile(this.jobName, taskName, "checkpoints");
    }

    public void writeCheckpoint(TaskName taskName, Checkpoint checkpoint) {
        byte[] bytes = this.serde.toBytes(checkpoint);
        FileOutputStream fos = new FileOutputStream(this.getCheckpointFile(taskName));
        fos.write(bytes);
        fos.close();
    }

    public Checkpoint readLastCheckpoint(TaskName taskName) {
        Checkpoint checkpoint;
        try {
            byte[] bytes = (byte[])Source$.MODULE$.fromFile(this.getCheckpointFile(taskName), Codec$.MODULE$.fallbackSystemCodec()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte apply(char x$1) {
                    return (byte)x$1;
                }
            }).toArray(ClassTag$.MODULE$.Byte());
            checkpoint = this.serde.fromBytes(bytes);
        }
        catch (FileNotFoundException fileNotFoundException) {
            checkpoint = null;
        }
        return checkpoint;
    }

    public void start() {
        if (this.root.exists()) {
            return;
        }
        throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("Root directory for file system checkpoint manager does not exist: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.root})));
    }

    public void stop() {
    }

    private File getFile(String jobName, TaskName taskName, String fileType) {
        return new File(this.root, new StringOps(Predef$.MODULE$.augmentString("%s-%s-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobName, taskName, fileType})));
    }

    public FileSystemCheckpointManager(String jobName, File root, CheckpointSerde serde) {
        this.jobName = jobName;
        this.root = root;
        this.serde = serde;
    }
}

