/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.checkpoint;

import org.apache.samza.checkpoint.CheckpointListener;
import org.apache.samza.checkpoint.CheckpointManager;
import org.apache.samza.checkpoint.OffsetManager;
import org.apache.samza.checkpoint.OffsetManagerMetrics;
import org.apache.samza.checkpoint.OffsetManagerMetrics$;
import org.apache.samza.checkpoint.OffsetSetting;
import org.apache.samza.config.Config;
import org.apache.samza.config.StreamConfig$;
import org.apache.samza.config.SystemConfig$;
import org.apache.samza.system.SystemAdmins;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.util.Logging;
import org.apache.samza.util.Logging$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class OffsetManager$
implements Logging {
    public static final OffsetManager$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    static {
        new OffsetManager$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        OffsetManager$ offsetManager$ = this;
        synchronized (offsetManager$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        OffsetManager$ offsetManager$ = this;
        synchronized (offsetManager$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging$class.startupLogger(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    @Override
    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    @Override
    public void startupLog(Function0<Object> message) {
        Logging$class.startupLog(this, message);
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.trace(this, message, e);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.debug(this, message, e);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.info(this, message, e);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.warn(this, message, e);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging$class.error(this, message);
    }

    @Override
    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging$class.error(this, message, e);
    }

    @Override
    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging$class.putMDC(this, key, value);
    }

    @Override
    public String getMDC(Function0<String> key) {
        return Logging$class.getMDC(this, key);
    }

    @Override
    public void removeMDC(Function0<String> key) {
        Logging$class.removeMDC(this, key);
    }

    @Override
    public void clearMDC() {
        Logging$class.clearMDC(this);
    }

    public OffsetManager apply(Map<SystemStream, SystemStreamMetadata> systemStreamMetadata, Config config, CheckpointManager checkpointManager, SystemAdmins systemAdmins, Map<String, CheckpointListener> checkpointListeners, OffsetManagerMetrics offsetManagerMetrics) {
        this.debug((Function0<Object>)new Serializable(systemStreamMetadata){
            public static final long serialVersionUID = 0L;
            private final Map systemStreamMetadata$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset manager for %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemStreamMetadata$1}));
            }
            {
                this.systemStreamMetadata$1 = systemStreamMetadata$1;
            }
        });
        scala.collection.immutable.Map offsetSettings = ((TraversableOnce)systemStreamMetadata.map((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final Tuple2<SystemStream, OffsetSetting> apply(Tuple2<SystemStream, SystemStreamMetadata> x0$1) {
                Tuple2<SystemStream, SystemStreamMetadata> tuple2 = x0$1;
                if (tuple2 != null) {
                    SystemStreamMetadata.OffsetType offsetType;
                    SystemStream systemStream = (SystemStream)tuple2._1();
                    SystemStreamMetadata systemStreamMetadata = (SystemStreamMetadata)tuple2._2();
                    Option<String> streamDefaultOffset = StreamConfig$.MODULE$.Config2Stream(this.config$1).getDefaultStreamOffset(systemStream);
                    Option<String> systemDefaultOffset = SystemConfig$.MODULE$.Config2System(this.config$1).getDefaultSystemOffset(systemStream.getSystem());
                    if (streamDefaultOffset.isDefined()) {
                        offsetType = SystemStreamMetadata.OffsetType.valueOf((String)((String)streamDefaultOffset.get()).toUpperCase());
                    } else if (systemDefaultOffset.isDefined()) {
                        offsetType = SystemStreamMetadata.OffsetType.valueOf((String)((String)systemDefaultOffset.get()).toUpperCase());
                    } else {
                        OffsetManager$.MODULE$.info((Function0<Object>)new Serializable(this, systemStream){
                            public static final long serialVersionUID = 0L;
                            private final SystemStream systemStream$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("No default offset for %s defined. Using upcoming.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.systemStream$1}));
                            }
                            {
                                this.systemStream$1 = systemStream$1;
                            }
                        });
                        offsetType = SystemStreamMetadata.OffsetType.UPCOMING;
                    }
                    SystemStreamMetadata.OffsetType defaultOffsetType = offsetType;
                    OffsetManager$.MODULE$.debug((Function0<Object>)new Serializable(this, systemStream, defaultOffsetType){
                        public static final long serialVersionUID = 0L;
                        private final SystemStream systemStream$1;
                        private final SystemStreamMetadata.OffsetType defaultOffsetType$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Using default offset %s for %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.defaultOffsetType$1, this.systemStream$1}));
                        }
                        {
                            this.systemStream$1 = systemStream$1;
                            this.defaultOffsetType$1 = defaultOffsetType$1;
                        }
                    });
                    boolean resetOffset = StreamConfig$.MODULE$.Config2Stream(this.config$1).getResetOffset(systemStream);
                    OffsetManager$.MODULE$.debug((Function0<Object>)new Serializable(this, systemStream, resetOffset){
                        public static final long serialVersionUID = 0L;
                        private final SystemStream systemStream$1;
                        private final boolean resetOffset$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Using reset offset %s for %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.resetOffset$1), this.systemStream$1}));
                        }
                        {
                            this.systemStream$1 = systemStream$1;
                            this.resetOffset$1 = resetOffset$1;
                        }
                    });
                    Tuple2 tuple22 = new Tuple2((Object)systemStream, (Object)new OffsetSetting(systemStreamMetadata, defaultOffsetType, resetOffset));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.config$1 = config$1;
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new OffsetManager((Map<SystemStream, OffsetSetting>)offsetSettings, checkpointManager, systemAdmins, checkpointListeners, offsetManagerMetrics);
    }

    public CheckpointManager apply$default$3() {
        return null;
    }

    public SystemAdmins apply$default$4() {
        return SystemAdmins.empty();
    }

    public Map<String, CheckpointListener> apply$default$5() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public OffsetManagerMetrics apply$default$6() {
        return new OffsetManagerMetrics(OffsetManagerMetrics$.MODULE$.$lessinit$greater$default$1());
    }

    public Map<SystemStream, OffsetSetting> $lessinit$greater$default$1() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public CheckpointManager $lessinit$greater$default$2() {
        return null;
    }

    public SystemAdmins $lessinit$greater$default$3() {
        return SystemAdmins.empty();
    }

    public Map<String, CheckpointListener> $lessinit$greater$default$4() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public OffsetManagerMetrics $lessinit$greater$default$5() {
        return new OffsetManagerMetrics(OffsetManagerMetrics$.MODULE$.$lessinit$greater$default$1());
    }

    private OffsetManager$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

