/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.checkpoint;

import java.util.regex.Pattern;
import joptsimple.OptionSet;
import org.apache.samza.SamzaException;
import org.apache.samza.checkpoint.CheckpointManager;
import org.apache.samza.checkpoint.CheckpointManagerFactory;
import org.apache.samza.checkpoint.CheckpointTool;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigRewriter;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.JobConfig$;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.TaskConfig$;
import org.apache.samza.container.TaskName;
import org.apache.samza.job.JobRunner$;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.util.Util$;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public final class CheckpointTool$ {
    public static final CheckpointTool$ MODULE$;
    private final String SSP_PATTERN;
    private final Pattern SSP_REGEX;

    static {
        new CheckpointTool$();
    }

    public String SSP_PATTERN() {
        return this.SSP_PATTERN;
    }

    public Pattern SSP_REGEX() {
        return this.SSP_REGEX;
    }

    public CheckpointTool apply(Config config, Map<TaskName, Map<SystemStreamPartition, String>> offsets) {
        Option<String> option = TaskConfig$.MODULE$.Config2Task(config).getCheckpointManagerFactory();
        if (option instanceof Some) {
            CheckpointManager checkpointManager;
            Some some = (Some)option;
            String className = (String)some.x();
            CheckpointManager manager = checkpointManager = Util$.MODULE$.getObj(className, CheckpointManagerFactory.class).getCheckpointManager(config, (MetricsRegistry)new MetricsRegistryMap());
            return new CheckpointTool(config, offsets, manager);
        }
        throw new SamzaException("This job does not use checkpointing (task.checkpoint.factory is not set).");
    }

    public Config rewriteConfig(JobConfig config) {
        JobConfig jobConfig;
        Option<String> option = config.getConfigRewriters();
        if (option instanceof Some) {
            Some some = (Some)option;
            String rewriters = (String)some.x();
            jobConfig = (Config)Predef$.MODULE$.refArrayOps((Object[])rewriters.split(",")).foldLeft((Object)config, (Function2)new Serializable(config){
                public static final long serialVersionUID = 0L;
                private final JobConfig config$1;

                public final JobConfig apply(JobConfig x$5, String x$6) {
                    return JobConfig$.MODULE$.Config2Job(CheckpointTool$.MODULE$.org$apache$samza$checkpoint$CheckpointTool$$rewrite$1(x$5, x$6, this.config$1));
                }
                {
                    this.config$1 = config$1;
                }
            });
        } else {
            jobConfig = config;
        }
        return jobConfig;
    }

    public void main(String[] args) {
        CheckpointTool.CheckpointToolCommandLine cmdline = new CheckpointTool.CheckpointToolCommandLine();
        OptionSet options = cmdline.parser().parse(args);
        MapConfig config = cmdline.loadConfig(options);
        Config rconfig = this.rewriteConfig(new JobConfig((Config)config));
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"Rewritten config").append((Object)rconfig).toString());
        CheckpointTool tool = this.apply(rconfig, cmdline.newOffsets());
        tool.run();
    }

    public final Config org$apache$samza$checkpoint$CheckpointTool$$rewrite$1(JobConfig c, String rewriterName, JobConfig config$1) {
        String rewriterClassName = (String)config$1.getConfigRewriterClass(rewriterName).getOrElse((Function0)new Serializable(rewriterName){
            public static final long serialVersionUID = 0L;
            private final String rewriterName$1;

            public final Nothing$ apply() {
                throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("Unable to find class config for config rewriter %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rewriterName$1})));
            }
            {
                this.rewriterName$1 = rewriterName$1;
            }
        });
        ConfigRewriter rewriter = Util$.MODULE$.getObj(rewriterClassName, ConfigRewriter.class);
        JobRunner$.MODULE$.info((Function0<Object>)new Serializable(rewriter){
            public static final long serialVersionUID = 0L;
            private final ConfigRewriter rewriter$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Re-writing config for CheckpointTool with ").append((Object)this.rewriter$1).toString();
            }
            {
                this.rewriter$1 = rewriter$1;
            }
        });
        return rewriter.rewrite(rewriterName, (Config)c);
    }

    private CheckpointTool$() {
        MODULE$ = this;
        this.SSP_PATTERN = "tasknames.%s.systems.%s.streams.%s.partitions.%d";
        this.SSP_REGEX = Pattern.compile("tasknames\\.(.+)\\.systems\\.(.+)\\.streams\\.(.+)\\.partitions\\.([0-9]+)");
    }
}

