/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.application.descriptors;

import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.TaskApplication;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.application.descriptors.TaskApplicationDescriptor;
import org.apache.samza.config.Config;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.table.descriptors.BaseTableDescriptor;
import org.apache.samza.table.descriptors.TableDescriptor;
import org.apache.samza.task.TaskFactory;

public class TaskApplicationDescriptorImpl
extends ApplicationDescriptorImpl<TaskApplicationDescriptor>
implements TaskApplicationDescriptor {
    private TaskFactory taskFactory = null;

    public TaskApplicationDescriptorImpl(TaskApplication userApp, Config config) {
        super((SamzaApplication)userApp, config);
        userApp.describe((ApplicationDescriptor)this);
    }

    public TaskApplicationDescriptor withTaskFactory(TaskFactory factory) {
        this.taskFactory = factory;
        return this;
    }

    public TaskApplicationDescriptor withInputStream(InputDescriptor inputDescriptor) {
        this.addInputDescriptor(inputDescriptor);
        this.getOrCreateStreamSerdes(inputDescriptor.getStreamId(), inputDescriptor.getSerde());
        return this;
    }

    public TaskApplicationDescriptor withOutputStream(OutputDescriptor outputDescriptor) {
        this.addOutputDescriptor(outputDescriptor);
        this.getOrCreateStreamSerdes(outputDescriptor.getStreamId(), outputDescriptor.getSerde());
        return this;
    }

    public TaskApplicationDescriptor withTable(TableDescriptor tableDescriptor) {
        this.addTableDescriptor(tableDescriptor);
        BaseTableDescriptor baseTableDescriptor = (BaseTableDescriptor)tableDescriptor;
        this.getOrCreateTableSerdes(baseTableDescriptor.getTableId(), baseTableDescriptor.getSerde());
        return this;
    }

    public TaskFactory getTaskFactory() {
        return this.taskFactory;
    }
}

