/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.application.descriptors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.SamzaException;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.application.descriptors.ApplicationDescriptorImpl;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.MessageStreamImpl;
import org.apache.samza.operators.OperatorSpecGraph;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.operators.TableImpl;
import org.apache.samza.operators.spec.InputOperatorSpec;
import org.apache.samza.operators.spec.OperatorSpec;
import org.apache.samza.operators.spec.OperatorSpecs;
import org.apache.samza.operators.spec.OutputStreamImpl;
import org.apache.samza.operators.stream.IntermediateMessageStreamImpl;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.InputTransformer;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.system.descriptors.StreamExpander;
import org.apache.samza.system.descriptors.SystemDescriptor;
import org.apache.samza.table.Table;
import org.apache.samza.table.descriptors.BaseTableDescriptor;
import org.apache.samza.table.descriptors.TableDescriptor;

public class StreamApplicationDescriptorImpl
extends ApplicationDescriptorImpl<StreamApplicationDescriptor>
implements StreamApplicationDescriptor {
    private final Set<String> intermediateBroadcastStreamIds = new HashSet<String>();
    private final Map<String, InputOperatorSpec> inputOperators = new LinkedHashMap<String, InputOperatorSpec>();
    private final Map<String, OutputStreamImpl> outputStreams = new LinkedHashMap<String, OutputStreamImpl>();
    private final Set<String> operatorIds = new HashSet<String>();
    private int nextOpNum = 0;

    public StreamApplicationDescriptorImpl(StreamApplication userApp, Config config) {
        super((SamzaApplication)userApp, config);
        userApp.describe((ApplicationDescriptor)this);
    }

    public <M> MessageStream<M> getInputStream(InputDescriptor<M, ?> inputDescriptor) {
        SystemDescriptor systemDescriptor = inputDescriptor.getSystemDescriptor();
        Optional expander = systemDescriptor.getExpander();
        if (expander.isPresent()) {
            return ((StreamExpander)expander.get()).apply((StreamApplicationDescriptor)this, inputDescriptor);
        }
        this.addInputDescriptor(inputDescriptor);
        String streamId = inputDescriptor.getStreamId();
        Serde serde = inputDescriptor.getSerde();
        KV<Serde, Serde> kvSerdes = this.getOrCreateStreamSerdes(streamId, serde);
        boolean isKeyed = serde instanceof KVSerde;
        InputTransformer transformer = inputDescriptor.getTransformer().orElse(null);
        InputOperatorSpec inputOperatorSpec = OperatorSpecs.createInputOperatorSpec(streamId, (Serde)kvSerdes.getKey(), (Serde)kvSerdes.getValue(), transformer, isKeyed, this.getNextOpId(OperatorSpec.OpCode.INPUT, null));
        this.inputOperators.put(streamId, inputOperatorSpec);
        return new MessageStreamImpl(this, this.inputOperators.get(streamId));
    }

    public <M> OutputStream<M> getOutputStream(OutputDescriptor<M, ?> outputDescriptor) {
        this.addOutputDescriptor(outputDescriptor);
        String streamId = outputDescriptor.getStreamId();
        Serde serde = outputDescriptor.getSerde();
        KV<Serde, Serde> kvSerdes = this.getOrCreateStreamSerdes(streamId, serde);
        boolean isKeyed = serde instanceof KVSerde;
        this.outputStreams.put(streamId, new OutputStreamImpl(streamId, (Serde)kvSerdes.getKey(), (Serde)kvSerdes.getValue(), isKeyed));
        return this.outputStreams.get(streamId);
    }

    public <K, V> Table<KV<K, V>> getTable(TableDescriptor<K, V, ?> tableDescriptor) {
        this.addTableDescriptor(tableDescriptor);
        BaseTableDescriptor baseTableDescriptor = (BaseTableDescriptor)tableDescriptor;
        this.getOrCreateTableSerdes(baseTableDescriptor.getTableId(), baseTableDescriptor.getSerde());
        return new TableImpl(baseTableDescriptor.getTableSpec());
    }

    @Override
    public Set<String> getInputStreamIds() {
        return Collections.unmodifiableSet(new HashSet<String>(this.inputOperators.keySet()));
    }

    @Override
    public Set<String> getOutputStreamIds() {
        return Collections.unmodifiableSet(new HashSet<String>(this.outputStreams.keySet()));
    }

    @Override
    public Set<String> getIntermediateBroadcastStreamIds() {
        return Collections.unmodifiableSet(this.intermediateBroadcastStreamIds);
    }

    @Override
    public Map<String, InputOperatorSpec> getInputOperators() {
        return Collections.unmodifiableMap(this.inputOperators);
    }

    public Map<String, OutputStreamImpl> getOutputStreams() {
        return Collections.unmodifiableMap(this.outputStreams);
    }

    public OperatorSpecGraph getOperatorSpecGraph() {
        return new OperatorSpecGraph(this);
    }

    public String getNextOpId(OperatorSpec.OpCode opCode, String userDefinedId) {
        if (StringUtils.isNotBlank((CharSequence)userDefinedId) && !ID_PATTERN.matcher(userDefinedId).matches()) {
            throw new SamzaException("Operator ID must not contain spaces or special characters: " + userDefinedId);
        }
        JobConfig jobConfig = new JobConfig(this.getConfig());
        String nextOpId = String.format("%s-%s-%s-%s", jobConfig.getName().get(), jobConfig.getJobId(), opCode.name().toLowerCase(), StringUtils.isNotBlank((CharSequence)userDefinedId) ? userDefinedId.trim() : String.valueOf(this.nextOpNum));
        if (!this.operatorIds.add(nextOpId)) {
            throw new SamzaException(String.format("Found duplicate operator ID %s in the graph. Operator IDs must be unique.", nextOpId));
        }
        ++this.nextOpNum;
        return nextOpId;
    }

    public String getNextOpId(OperatorSpec.OpCode opCode) {
        return this.getNextOpId(opCode, null);
    }

    @VisibleForTesting
    public <M> IntermediateMessageStreamImpl<M> getIntermediateStream(String streamId, Serde<M> serde, boolean isBroadcast) {
        Preconditions.checkNotNull(serde, (Object)("serde must not be null for intermediate stream: " + streamId));
        Preconditions.checkState((!this.inputOperators.containsKey(streamId) && !this.outputStreams.containsKey(streamId) ? 1 : 0) != 0, (Object)("getIntermediateStream must not be called multiple times with the same streamId: " + streamId));
        if (isBroadcast) {
            this.intermediateBroadcastStreamIds.add(streamId);
        }
        boolean isKeyed = serde instanceof KVSerde;
        KV<Serde, Serde> kvSerdes = this.getOrCreateStreamSerdes(streamId, serde);
        InputTransformer transformer = this.getDefaultSystemDescriptor().flatMap(SystemDescriptor::getTransformer).orElse(null);
        InputOperatorSpec inputOperatorSpec = OperatorSpecs.createInputOperatorSpec(streamId, (Serde)kvSerdes.getKey(), (Serde)kvSerdes.getValue(), transformer, isKeyed, this.getNextOpId(OperatorSpec.OpCode.INPUT, null));
        this.inputOperators.put(streamId, inputOperatorSpec);
        this.outputStreams.put(streamId, new OutputStreamImpl(streamId, (Serde)kvSerdes.getKey(), (Serde)kvSerdes.getValue(), isKeyed));
        return new IntermediateMessageStreamImpl(this, this.inputOperators.get(streamId), this.outputStreams.get(streamId));
    }
}

