/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.application.descriptors;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.descriptors.ApplicationDescriptor;
import org.apache.samza.config.Config;
import org.apache.samza.context.ApplicationContainerContext;
import org.apache.samza.context.ApplicationContainerContextFactory;
import org.apache.samza.context.ApplicationTaskContext;
import org.apache.samza.context.ApplicationTaskContextFactory;
import org.apache.samza.metrics.MetricsReporterFactory;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.spec.InputOperatorSpec;
import org.apache.samza.runtime.ProcessorLifecycleListener;
import org.apache.samza.runtime.ProcessorLifecycleListenerFactory;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.system.descriptors.SystemDescriptor;
import org.apache.samza.table.descriptors.BaseHybridTableDescriptor;
import org.apache.samza.table.descriptors.TableDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationDescriptorImpl<S extends ApplicationDescriptor>
implements ApplicationDescriptor<S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationDescriptorImpl.class);
    static final Pattern ID_PATTERN = Pattern.compile("[\\d\\w-_]+");
    private final Class<? extends SamzaApplication> appClass;
    private final Config config;
    private final Map<String, InputDescriptor> inputDescriptors = new LinkedHashMap<String, InputDescriptor>();
    private final Map<String, OutputDescriptor> outputDescriptors = new LinkedHashMap<String, OutputDescriptor>();
    private final Map<String, SystemDescriptor> systemDescriptors = new LinkedHashMap<String, SystemDescriptor>();
    private final Map<String, TableDescriptor> tableDescriptors = new LinkedHashMap<String, TableDescriptor>();
    private Optional<SystemDescriptor> defaultSystemDescriptorOptional = Optional.empty();
    private final Map<String, MetricsReporterFactory> reporterFactories = new LinkedHashMap<String, MetricsReporterFactory>();
    private final Map<String, KV<Serde, Serde>> streamSerdes = new HashMap<String, KV<Serde, Serde>>();
    private final Map<String, KV<Serde, Serde>> tableSerdes = new HashMap<String, KV<Serde, Serde>>();
    private Optional<ApplicationContainerContextFactory<?>> applicationContainerContextFactoryOptional = Optional.empty();
    private Optional<ApplicationTaskContextFactory<?>> applicationTaskContextFactoryOptional = Optional.empty();
    ProcessorLifecycleListenerFactory listenerFactory = (ProcessorLifecycleListenerFactory & Serializable)(pcontext, cfg) -> new ProcessorLifecycleListener(){};

    ApplicationDescriptorImpl(SamzaApplication app, Config config) {
        this.config = config;
        this.appClass = app.getClass();
    }

    public Config getConfig() {
        return this.config;
    }

    public S withDefaultSystem(SystemDescriptor<?> defaultSystemDescriptor) {
        Preconditions.checkNotNull(defaultSystemDescriptor, (Object)"Provided defaultSystemDescriptor must not be null.");
        Preconditions.checkState((this.getInputStreamIds().isEmpty() && this.getOutputStreamIds().isEmpty() ? 1 : 0) != 0, (Object)"Default system must be set before creating any input or output streams.");
        this.addSystemDescriptor(defaultSystemDescriptor);
        this.defaultSystemDescriptorOptional = Optional.of(defaultSystemDescriptor);
        return (S)this;
    }

    public S withApplicationContainerContextFactory(ApplicationContainerContextFactory<?> factory) {
        this.applicationContainerContextFactoryOptional = Optional.of(factory);
        return (S)this;
    }

    public S withApplicationTaskContextFactory(ApplicationTaskContextFactory<?> factory) {
        this.applicationTaskContextFactoryOptional = Optional.of(factory);
        return (S)this;
    }

    public S withProcessorLifecycleListenerFactory(ProcessorLifecycleListenerFactory listenerFactory) {
        this.listenerFactory = listenerFactory;
        return (S)this;
    }

    public S withMetricsReporterFactories(Map<String, MetricsReporterFactory> reporterFactories) {
        this.reporterFactories.clear();
        this.reporterFactories.putAll(reporterFactories);
        return (S)this;
    }

    public Class<? extends SamzaApplication> getAppClass() {
        return this.appClass;
    }

    public Optional<ApplicationContainerContextFactory<ApplicationContainerContext>> getApplicationContainerContextFactory() {
        Optional<ApplicationContainerContextFactory<ApplicationContainerContext>> factoryOptional = this.applicationContainerContextFactoryOptional;
        return factoryOptional;
    }

    public Optional<ApplicationTaskContextFactory<ApplicationTaskContext>> getApplicationTaskContextFactory() {
        Optional<ApplicationTaskContextFactory<ApplicationTaskContext>> factoryOptional = this.applicationTaskContextFactoryOptional;
        return factoryOptional;
    }

    public ProcessorLifecycleListenerFactory getProcessorLifecycleListenerFactory() {
        return this.listenerFactory;
    }

    public Map<String, MetricsReporterFactory> getMetricsReporterFactories() {
        return Collections.unmodifiableMap(this.reporterFactories);
    }

    public Set<String> getInputStreamIds() {
        return Collections.unmodifiableSet(new HashSet<String>(this.inputDescriptors.keySet()));
    }

    public Set<String> getOutputStreamIds() {
        return Collections.unmodifiableSet(new HashSet<String>(this.outputDescriptors.keySet()));
    }

    public Set<String> getIntermediateBroadcastStreamIds() {
        return Collections.emptySet();
    }

    public Map<String, InputDescriptor> getInputDescriptors() {
        return Collections.unmodifiableMap(this.inputDescriptors);
    }

    public Map<String, OutputDescriptor> getOutputDescriptors() {
        return Collections.unmodifiableMap(this.outputDescriptors);
    }

    public Set<SystemDescriptor> getSystemDescriptors() {
        return Collections.unmodifiableSet(new HashSet<SystemDescriptor>(this.systemDescriptors.values()));
    }

    public Optional<SystemDescriptor> getDefaultSystemDescriptor() {
        return this.defaultSystemDescriptorOptional;
    }

    public Set<TableDescriptor> getTableDescriptors() {
        return Collections.unmodifiableSet(new HashSet<TableDescriptor>(this.tableDescriptors.values()));
    }

    public Map<String, InputOperatorSpec> getInputOperators() {
        return Collections.emptyMap();
    }

    public KV<Serde, Serde> getStreamSerdes(String streamId) {
        return this.streamSerdes.get(streamId);
    }

    public KV<Serde, Serde> getTableSerdes(String tableId) {
        return this.tableSerdes.get(tableId);
    }

    KV<Serde, Serde> getOrCreateStreamSerdes(String streamId, Serde serde) {
        Serde valueSerde;
        Serde keySerde;
        KV<Serde, Serde> currentSerdePair = this.streamSerdes.get(streamId);
        if (serde instanceof KVSerde) {
            keySerde = ((KVSerde)serde).getKeySerde();
            valueSerde = ((KVSerde)serde).getValueSerde();
        } else {
            keySerde = new NoOpSerde();
            valueSerde = serde;
        }
        if (currentSerdePair == null) {
            if (keySerde instanceof NoOpSerde) {
                LOGGER.info("Using NoOpSerde as the key serde for stream " + streamId + ". Keys will not be (de)serialized");
            }
            if (valueSerde instanceof NoOpSerde) {
                LOGGER.info("Using NoOpSerde as the value serde for stream " + streamId + ". Values will not be (de)serialized");
            }
            this.streamSerdes.put(streamId, (KV<Serde, Serde>)KV.of((Object)keySerde, (Object)valueSerde));
        } else if (!((Serde)currentSerdePair.getKey()).equals(keySerde) || !((Serde)currentSerdePair.getValue()).equals(valueSerde)) {
            throw new IllegalArgumentException(String.format("Serde for streamId: %s is already defined. Cannot change it to different serdes.", streamId));
        }
        return this.streamSerdes.get(streamId);
    }

    KV<Serde, Serde> getOrCreateTableSerdes(String tableId, KVSerde kvSerde) {
        Serde keySerde = kvSerde.getKeySerde();
        Serde valueSerde = kvSerde.getValueSerde();
        if (!this.tableSerdes.containsKey(tableId)) {
            this.tableSerdes.put(tableId, (KV<Serde, Serde>)KV.of((Object)keySerde, (Object)valueSerde));
            return this.tableSerdes.get(tableId);
        }
        KV<Serde, Serde> currentSerdePair = this.tableSerdes.get(tableId);
        if (!((Serde)currentSerdePair.getKey()).equals(keySerde) || !((Serde)currentSerdePair.getValue()).equals(valueSerde)) {
            throw new IllegalArgumentException(String.format("Serde for table %s is already defined. Cannot change it to different serdes.", tableId));
        }
        return this.streamSerdes.get(tableId);
    }

    final void addInputDescriptor(InputDescriptor inputDescriptor) {
        String streamId = inputDescriptor.getStreamId();
        Preconditions.checkState((!this.inputDescriptors.containsKey(streamId) || this.inputDescriptors.get(streamId) == inputDescriptor ? 1 : 0) != 0, (Object)String.format("Cannot add multiple input descriptors with the same streamId: %s", streamId));
        this.inputDescriptors.put(streamId, inputDescriptor);
        this.addSystemDescriptor(inputDescriptor.getSystemDescriptor());
    }

    final void addOutputDescriptor(OutputDescriptor outputDescriptor) {
        String streamId = outputDescriptor.getStreamId();
        Preconditions.checkState((!this.outputDescriptors.containsKey(streamId) || this.outputDescriptors.get(streamId) == outputDescriptor ? 1 : 0) != 0, (Object)String.format("Cannot add an output descriptor multiple times with the same streamId: %s", streamId));
        this.outputDescriptors.put(streamId, outputDescriptor);
        this.addSystemDescriptor(outputDescriptor.getSystemDescriptor());
    }

    final void addTableDescriptor(TableDescriptor tableDescriptor) {
        String tableId = tableDescriptor.getTableId();
        Preconditions.checkState((StringUtils.isNotBlank((CharSequence)tableId) && ID_PATTERN.matcher(tableId).matches() ? 1 : 0) != 0, (Object)String.format("tableId: %s must confirm to pattern: %s", tableId, ID_PATTERN.toString()));
        Preconditions.checkState((!this.tableDescriptors.containsKey(tableId) || this.tableDescriptors.get(tableId) == tableDescriptor ? 1 : 0) != 0, (Object)String.format("Cannot add multiple table descriptors with the same tableId: %s", tableId));
        if (tableDescriptor instanceof BaseHybridTableDescriptor) {
            List tableDescs = ((BaseHybridTableDescriptor)tableDescriptor).getTableDescriptors();
            tableDescs.forEach(td -> this.addTableDescriptor((TableDescriptor)td));
        }
        this.tableDescriptors.put(tableId, tableDescriptor);
    }

    private void addSystemDescriptor(SystemDescriptor systemDescriptor) {
        String systemName = systemDescriptor.getSystemName();
        Preconditions.checkState((!this.systemDescriptors.containsKey(systemName) || this.systemDescriptors.get(systemName) == systemDescriptor ? 1 : 0) != 0, (Object)("Must not use different system descriptor instances for the same system name: " + systemName));
        this.systemDescriptors.put(systemName, systemDescriptor);
    }
}

