/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.application;

import org.apache.commons.lang3.StringUtils;
import org.apache.samza.application.LegacyTaskApplication;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.application.TaskApplication;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigException;
import org.apache.samza.config.TaskConfig;
import scala.Option;

public class ApplicationUtil {
    public static SamzaApplication fromConfig(Config config) {
        Option<String> taskClassOption;
        String appClassName = new ApplicationConfig(config).getAppClass();
        if (StringUtils.isNotBlank((CharSequence)appClassName)) {
            try {
                Class<?> appClass = Class.forName(appClassName);
                if (StreamApplication.class.isAssignableFrom(appClass) || TaskApplication.class.isAssignableFrom(appClass)) {
                    return (SamzaApplication)appClass.newInstance();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new ConfigException(String.format("Loading app.class %s failed. The user application has to implement StreamApplication or TaskApplication.", appClassName), (Throwable)e);
            }
        }
        if (!(taskClassOption = new TaskConfig(config).getTaskClass()).isDefined() || !StringUtils.isNotBlank((CharSequence)((CharSequence)taskClassOption.getOrElse(null)))) {
            throw new ConfigException("Legacy task applications must set a non-empty task.class in configuration.");
        }
        return new LegacyTaskApplication((String)taskClassOption.get());
    }
}

