/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.tools.json;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.operators.KV;
import org.apache.samza.sql.SamzaSqlRelRecord;
import org.apache.samza.sql.data.SamzaSqlRelMessage;
import org.apache.samza.sql.interfaces.RelSchemaProvider;
import org.apache.samza.sql.interfaces.SamzaRelConverter;
import org.apache.samza.sql.interfaces.SamzaRelConverterFactory;
import org.apache.samza.system.SystemStream;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class JsonRelConverterFactory
implements SamzaRelConverterFactory {
    ObjectMapper mapper = new ObjectMapper();

    public SamzaRelConverter create(SystemStream systemStream, RelSchemaProvider relSchemaProvider, Config config) {
        return new JsonRelConverter();
    }

    public class JsonRelConverter
    implements SamzaRelConverter {
        public SamzaSqlRelMessage convertToRelMessage(KV<Object, Object> kv) {
            throw new NotImplementedException();
        }

        public KV<Object, Object> convertToSamzaMessage(SamzaSqlRelMessage relMessage) {
            String jsonValue = this.convertToSamzaMessage(relMessage.getSamzaSqlRelRecord());
            return new KV(relMessage.getKey(), (Object)jsonValue.getBytes());
        }

        private String convertToSamzaMessage(SamzaSqlRelRecord relRecord) {
            String jsonValue;
            ObjectNode node = JsonRelConverterFactory.this.mapper.createObjectNode();
            List fieldNames = relRecord.getFieldNames();
            List values = relRecord.getFieldValues();
            for (int index = 0; index < fieldNames.size(); ++index) {
                Object value = values.get(index);
                if (value == null) continue;
                if (Long.class.isAssignableFrom(value.getClass())) {
                    node.put((String)fieldNames.get(index), (Long)value);
                    continue;
                }
                if (Integer.class.isAssignableFrom(value.getClass())) {
                    node.put((String)fieldNames.get(index), (Integer)value);
                    continue;
                }
                if (Double.class.isAssignableFrom(value.getClass())) {
                    node.put((String)fieldNames.get(index), (Double)value);
                    continue;
                }
                if (String.class.isAssignableFrom(value.getClass())) {
                    node.put((String)fieldNames.get(index), (String)value);
                    continue;
                }
                if (SamzaSqlRelRecord.class.isAssignableFrom(value.getClass())) {
                    node.put((String)fieldNames.get(index), this.convertToSamzaMessage((SamzaSqlRelRecord)value));
                    continue;
                }
                node.put((String)fieldNames.get(index), value.toString());
            }
            try {
                jsonValue = JsonRelConverterFactory.this.mapper.writeValueAsString((Object)node);
            }
            catch (IOException e) {
                throw new SamzaException("Error json serializing object", (Throwable)e);
            }
            return jsonValue;
        }
    }
}

