/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.tools.benchmark;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.samza.Partition;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.tools.CommandLineHelper;
import org.apache.samza.tools.RandomValueGenerator;
import org.apache.samza.tools.benchmark.AbstractSamzaBench;
import org.apache.samza.util.NoOpMetricsRegistry;

public class SystemProducerBench
extends AbstractSamzaBench {
    private static final String OPT_SHORT_MESSAGE_SIZE = "sz";
    private static final String OPT_LONG_MESSAGE_SIZE = "size";
    private static final String OPT_ARG_MESSAGE_SIZE = "MESSAGE_SIZE";
    private static final String OPT_DESC_MESSAGE_SIZE = "Size of the message in bytes.";
    private byte[] value;

    public static void main(String[] args) throws Exception {
        SystemProducerBench bench = new SystemProducerBench(args);
        bench.start();
    }

    public SystemProducerBench(String[] args) throws ParseException {
        super("system-producer", args);
    }

    @Override
    public void addOptions(Options options) {
        options.addOption(CommandLineHelper.createOption(OPT_SHORT_MESSAGE_SIZE, OPT_LONG_MESSAGE_SIZE, OPT_ARG_MESSAGE_SIZE, true, OPT_DESC_MESSAGE_SIZE));
    }

    @Override
    public void start() throws IOException, InterruptedException {
        super.start();
        String source = "SystemProducerBench";
        int size = Integer.parseInt(this.cmd.getOptionValue(OPT_SHORT_MESSAGE_SIZE));
        RandomValueGenerator randGenerator = new RandomValueGenerator(System.currentTimeMillis());
        this.value = randGenerator.getNextString(size, size).getBytes();
        NoOpMetricsRegistry metricsRegistry = new NoOpMetricsRegistry();
        List<SystemStreamPartition> ssps = this.createSSPs(this.systemName, this.physicalStreamName, this.startPartition, this.endPartition);
        SystemProducer producer = this.factory.getProducer(this.systemName, this.config, (MetricsRegistry)metricsRegistry);
        producer.register(source);
        producer.start();
        System.out.println("starting production at " + Instant.now());
        Instant startTime = Instant.now();
        for (int index = 0; index < this.totalEvents; ++index) {
            SystemStreamPartition ssp = ssps.get(index % ssps.size());
            OutgoingMessageEnvelope messageEnvelope = this.createMessageEnvelope(ssp, index);
            producer.send(source, messageEnvelope);
        }
        System.out.println("Ending production at " + Instant.now());
        System.out.println(String.format("Event Rate is %s Messages/Sec", (long)(this.totalEvents * 1000) / Duration.between(startTime, Instant.now()).toMillis()));
        producer.flush(source);
        System.out.println("Ending flush at " + Instant.now());
        System.out.println(String.format("Event Rate with flush is %s Messages/Sec", (long)(this.totalEvents * 1000) / Duration.between(startTime, Instant.now()).toMillis()));
        producer.stop();
        System.exit(0);
    }

    OutgoingMessageEnvelope createMessageEnvelope(SystemStreamPartition ssp, int index) {
        return new OutgoingMessageEnvelope(ssp.getSystemStream(), (Object)String.valueOf(index), (Object)this.value);
    }

    List<SystemStreamPartition> createSSPs(String systemName, String physicalStreamName, int startPartition, int endPartition) {
        return IntStream.range(startPartition, endPartition).mapToObj(x -> new SystemStreamPartition(systemName, physicalStreamName, new Partition(x))).collect(Collectors.toList());
    }
}

