/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.tools.benchmark;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.cli.ParseException;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.SystemConfig;
import org.apache.samza.config.TaskConfig;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ApplicationRunners;
import org.apache.samza.runtime.LocalApplicationRunner;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.standalone.PassthroughJobCoordinatorFactory;
import org.apache.samza.system.descriptors.GenericInputDescriptor;
import org.apache.samza.system.descriptors.GenericSystemDescriptor;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.tools.benchmark.AbstractSamzaBench;
import org.apache.samza.tools.benchmark.ConfigBasedSspGrouperFactory;
import org.apache.samza.tools.benchmark.SystemConsumerBench;

public class SystemConsumerWithSamzaBench
extends AbstractSamzaBench {
    public SystemConsumerWithSamzaBench(String[] args) throws ParseException {
        super("system-consumer-with-samza-bench", args);
    }

    public static void main(String[] args) throws Exception {
        SystemConsumerBench bench = new SystemConsumerBench(args);
        bench.start();
    }

    @Override
    public void addMoreSystemConfigs(Properties props) {
        props.put("app.runner.class", LocalApplicationRunner.class.getName());
        List partitions = IntStream.range(this.startPartition, this.endPartition).boxed().collect(Collectors.toList());
        props.put(JobConfig.JOB_NAME(), "SamzaBench");
        props.put(JobConfig.PROCESSOR_ID(), "1");
        props.put("job.coordinator.factory", PassthroughJobCoordinatorFactory.class.getName());
        props.put(String.format("streams.%s.partitions", this.streamId), Joiner.on((String)",").join(partitions));
        props.put(TaskConfig.GROUPER_FACTORY(), ConfigBasedSspGrouperFactory.class.getName());
    }

    @Override
    public void start() throws IOException, InterruptedException {
        super.start();
        MessageConsumer consumeFn = new MessageConsumer();
        StreamApplication app = appDesc -> {
            String systemFactoryName = (String)new SystemConfig(this.config).getSystemFactory(this.systemName).get();
            GenericSystemDescriptor sd = new GenericSystemDescriptor(this.systemName, systemFactoryName);
            GenericInputDescriptor isd = sd.getInputDescriptor(this.streamId, (Serde)new NoOpSerde());
            MessageStream stream = appDesc.getInputStream((InputDescriptor)isd);
            stream.map((MapFunction)consumeFn);
        };
        ApplicationRunner runner = ApplicationRunners.getApplicationRunner((SamzaApplication)app, (Config)new MapConfig());
        runner.run();
        while (consumeFn.getEventsConsumed() < this.totalEvents) {
            Thread.sleep(10L);
        }
        Instant endTime = Instant.now();
        runner.kill();
        System.out.println("\n*******************");
        System.out.println(String.format("Started at %s Ending at %s ", consumeFn.startTime, endTime));
        System.out.println(String.format("Event Rate is %s Messages/Sec ", (long)(consumeFn.getEventsConsumed() * 1000) / Duration.between(consumeFn.startTime, Instant.now()).toMillis()));
        System.out.println("Event Rate is " + (long)(consumeFn.getEventsConsumed() * 1000) / Duration.between(consumeFn.startTime, endTime).toMillis());
        System.out.println("*******************\n");
        System.exit(0);
    }

    private class MessageConsumer
    implements MapFunction<Object, Object> {
        AtomicInteger eventsConsumed = new AtomicInteger(0);
        volatile Instant startTime;

        private MessageConsumer() {
        }

        public Object apply(Object message) {
            this.eventsConsumed.incrementAndGet();
            if (this.eventsConsumed.get() == 1) {
                this.startTime = Instant.now();
            }
            return message;
        }

        public int getEventsConsumed() {
            return this.eventsConsumed.get();
        }
    }
}

