/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.tools.benchmark;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.cli.ParseException;
import org.apache.samza.Partition;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.tools.benchmark.AbstractSamzaBench;
import org.apache.samza.util.NoOpMetricsRegistry;

public class SystemConsumerBench
extends AbstractSamzaBench {
    public static void main(String[] args) throws Exception {
        SystemConsumerBench bench = new SystemConsumerBench(args);
        bench.start();
    }

    public SystemConsumerBench(String[] args) throws ParseException {
        super("system-consumer-bench", args);
    }

    @Override
    public void start() throws IOException, InterruptedException {
        int numEvents;
        Map pollResult;
        super.start();
        SystemAdmin systemAdmin = this.factory.getAdmin(this.systemName, this.config);
        SystemStreamMetadata ssm = (SystemStreamMetadata)systemAdmin.getSystemStreamMetadata(Collections.singleton(this.physicalStreamName)).get(this.physicalStreamName);
        NoOpMetricsRegistry metricsRegistry = new NoOpMetricsRegistry();
        Set<SystemStreamPartition> ssps = this.createSSPs(this.systemName, this.physicalStreamName, this.startPartition, this.endPartition);
        SystemConsumer consumer = this.factory.getConsumer(this.systemName, this.config, (MetricsRegistry)metricsRegistry);
        for (SystemStreamPartition ssp : ssps) {
            consumer.register(ssp, ((SystemStreamMetadata.SystemStreamPartitionMetadata)ssm.getSystemStreamPartitionMetadata().get(ssp.getPartition())).getOldestOffset());
        }
        consumer.start();
        System.out.println("starting consumption at " + Instant.now());
        Instant startTime = Instant.now();
        for (numEvents = 0; numEvents < this.totalEvents; numEvents += pollResult.values().stream().mapToInt(List::size).sum()) {
            pollResult = consumer.poll(ssps, 2000L);
        }
        System.out.println("Ending consumption at " + Instant.now());
        System.out.println(String.format("Event Rate is %s Messages/Sec ", (long)(numEvents * 1000) / Duration.between(startTime, Instant.now()).toMillis()));
        consumer.stop();
        System.exit(0);
    }

    Set<SystemStreamPartition> createSSPs(String systemName, String physicalStreamName, int startPartition, int endPartition) {
        return IntStream.range(startPartition, endPartition).mapToObj(x -> new SystemStreamPartition(systemName, physicalStreamName, new Partition(x))).collect(Collectors.toSet());
    }
}

