/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.tools.benchmark;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.samza.config.Config;
import org.apache.samza.container.TaskName;
import org.apache.samza.container.grouper.stream.SystemStreamPartitionGrouper;
import org.apache.samza.container.grouper.stream.SystemStreamPartitionGrouperFactory;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamPartition;

class ConfigBasedSspGrouperFactory
implements SystemStreamPartitionGrouperFactory {
    public static final String CONFIG_STREAM_PARTITIONS = "streams.%s.partitions";
    private static final String CFG_PARTITIONS_DELIMITER = ",";

    ConfigBasedSspGrouperFactory() {
    }

    public SystemStreamPartitionGrouper getSystemStreamPartitionGrouper(Config config) {
        return new ConfigBasedSspGrouper(config);
    }

    private class ConfigBasedSspGrouper
    implements SystemStreamPartitionGrouper {
        private final Config config;
        private HashMap<String, Set<Integer>> _streamPartitionsMap = new HashMap();

        public ConfigBasedSspGrouper(Config config) {
            this.config = config;
        }

        public Map<TaskName, Set<SystemStreamPartition>> group(Set<SystemStreamPartition> ssps) {
            HashSet<SystemStreamPartition> filteredSsps = new HashSet<SystemStreamPartition>();
            for (SystemStreamPartition ssp : ssps) {
                Set<Integer> partitions = this.getPartitions(ssp.getSystemStream());
                if (!partitions.contains(ssp.getPartition().getPartitionId())) continue;
                filteredSsps.add(ssp);
            }
            HashMap<TaskName, Set<SystemStreamPartition>> group = new HashMap<TaskName, Set<SystemStreamPartition>>();
            group.put(new TaskName("TestTask"), filteredSsps);
            return group;
        }

        private Set<Integer> getPartitions(SystemStream systemStream) {
            String streamName = systemStream.getStream();
            if (!this._streamPartitionsMap.containsKey(streamName)) {
                String partitions = (String)this.config.get((Object)String.format(ConfigBasedSspGrouperFactory.CONFIG_STREAM_PARTITIONS, streamName));
                this._streamPartitionsMap.put(streamName, Arrays.stream(partitions.split(ConfigBasedSspGrouperFactory.CFG_PARTITIONS_DELIMITER)).map(Integer::parseInt).collect(Collectors.toSet()));
            }
            return this._streamPartitionsMap.get(streamName);
        }
    }
}

