/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.tools.benchmark;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.sql.testutil.ReflectionUtils;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.tools.CommandLineHelper;

public abstract class AbstractSamzaBench {
    protected static final String OPT_SHORT_PROPERTIES_FILE = "p";
    protected static final String OPT_LONG_PROPERTIES_FILE = "props";
    protected static final String OPT_ARG_PROPERTIES_FILE = "PROPERTIES_FILE";
    protected static final String OPT_DESC_PROPERTIES_FILE = "Path to the properties file.";
    protected static final String OPT_SHORT_NUM_EVENTS = "n";
    protected static final String OPT_LONG_NUM_EVENTS = "numEvents";
    protected static final String OPT_ARG_NUM_EVENTS = "NUMBER_EVENTS";
    protected static final String OPT_DESC_NUM_EVENTS = "Total number of events to consume.";
    protected static final String OPT_SHORT_START_PARTITION = "sp";
    protected static final String OPT_LONG_START_PARTITION = "startPartition";
    protected static final String OPT_ARG_START_PARTITION = "START_PARTITION";
    protected static final String OPT_DESC_START_PARTITION = "Start partition.";
    protected static final String OPT_SHORT_END_PARTITION = "ep";
    protected static final String OPT_LONG_END_PARTITION = "endPartition";
    protected static final String OPT_ARG_END_PARTITION = "END_PARTITION";
    protected static final String OPT_DESC_END_PARTITION = "End partition.";
    protected static final String OPT_SHORT_STREAM = "s";
    protected static final String OPT_LONG_STREAM = "streamId";
    protected static final String OPT_ARG_STREAM = "STREAM_ID";
    protected static final String OPT_DESC_STREAM = "STREAM ID.";
    protected static final String CFG_STREAM_SYSTEM_NAME = "streams.%s.samza.system";
    protected static final String CFG_SYSTEM_FACTORY = "systems.%s.samza.factory";
    protected static final String CFG_PHYSICAL_STREAM_NAME = "streams.%s.samza.physical.name";
    protected final Options options = new Options();
    protected final CommandLine cmd;
    protected SystemFactory factory;
    protected Config config;
    protected String systemName;
    protected String physicalStreamName;
    protected int startPartition;
    protected int endPartition;
    protected int totalEvents;
    protected String streamId;

    public AbstractSamzaBench(String scriptName, String[] args) throws ParseException {
        this.options.addOption(CommandLineHelper.createOption(OPT_SHORT_PROPERTIES_FILE, OPT_LONG_PROPERTIES_FILE, OPT_ARG_PROPERTIES_FILE, true, OPT_DESC_PROPERTIES_FILE));
        this.options.addOption(CommandLineHelper.createOption(OPT_SHORT_NUM_EVENTS, OPT_LONG_NUM_EVENTS, OPT_ARG_NUM_EVENTS, true, OPT_DESC_NUM_EVENTS));
        this.options.addOption(CommandLineHelper.createOption(OPT_SHORT_START_PARTITION, OPT_LONG_START_PARTITION, OPT_ARG_START_PARTITION, true, OPT_DESC_START_PARTITION));
        this.options.addOption(CommandLineHelper.createOption(OPT_SHORT_END_PARTITION, OPT_LONG_END_PARTITION, OPT_ARG_END_PARTITION, true, OPT_DESC_END_PARTITION));
        this.options.addOption(CommandLineHelper.createOption(OPT_SHORT_STREAM, OPT_LONG_STREAM, OPT_ARG_STREAM, true, OPT_DESC_STREAM));
        this.addOptions(this.options);
        BasicParser parser = new BasicParser();
        try {
            this.cmd = parser.parse(this.options, args);
        }
        catch (Exception e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(String.format("Error: %s.sh", scriptName), this.options);
            throw e;
        }
    }

    public void start() throws IOException, InterruptedException {
        this.startPartition = Integer.parseInt(this.cmd.getOptionValue(OPT_SHORT_START_PARTITION));
        this.endPartition = Integer.parseInt(this.cmd.getOptionValue(OPT_SHORT_END_PARTITION));
        this.totalEvents = Integer.parseInt(this.cmd.getOptionValue(OPT_SHORT_NUM_EVENTS));
        String propsFile = this.cmd.getOptionValue(OPT_SHORT_PROPERTIES_FILE);
        this.streamId = this.cmd.getOptionValue(OPT_SHORT_STREAM);
        Properties props = new Properties();
        props.load(new FileInputStream(propsFile));
        this.addMoreSystemConfigs(props);
        this.config = this.convertToSamzaConfig(props);
        this.systemName = (String)this.config.get((Object)String.format(CFG_STREAM_SYSTEM_NAME, this.streamId));
        String systemFactory = (String)this.config.get((Object)String.format(CFG_SYSTEM_FACTORY, this.systemName));
        this.physicalStreamName = (String)this.config.get((Object)String.format(CFG_PHYSICAL_STREAM_NAME, this.streamId));
        this.factory = (SystemFactory)ReflectionUtils.createInstance((String)systemFactory, (Object[])new Object[0]);
        if (this.factory == null) {
            throw new RuntimeException("Cannot instantiate systemfactory " + systemFactory);
        }
    }

    protected void addMoreSystemConfigs(Properties props) {
    }

    protected void addOptions(Options options) {
    }

    Config convertToSamzaConfig(Properties props) {
        Map propsValue = props.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), props::getProperty));
        return new MapConfig(propsValue);
    }
}

