/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.tools.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.SerdeFactory;

public class AvroSerDeFactory
implements SerdeFactory {
    public static String CFG_AVRO_SCHEMA = "serializers.avro.schema";

    public Serde getSerde(String name, Config config) {
        return new AvroSerDe(config);
    }

    private byte[] encodeAvroGenericRecord(Schema schema, GenericRecord record) throws IOException {
        GenericDatumWriter msgDatumWriter = new GenericDatumWriter(schema);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)os, null);
        msgDatumWriter.write((Object)record, (Encoder)encoder);
        encoder.flush();
        return os.toByteArray();
    }

    private static <T> T genericRecordFromBytes(byte[] bytes, Schema schema) throws IOException {
        BinaryDecoder binDecoder = DecoderFactory.defaultFactory().createBinaryDecoder(bytes, null);
        GenericDatumReader reader = new GenericDatumReader(schema);
        return (T)reader.read(null, (Decoder)binDecoder);
    }

    private class AvroSerDe
    implements Serde {
        private final Schema schema;

        public AvroSerDe(Config config) {
            this.schema = Schema.parse((String)((String)config.get((Object)CFG_AVRO_SCHEMA)));
        }

        public Object fromBytes(byte[] bytes) {
            GenericRecord record;
            try {
                record = (GenericRecord)AvroSerDeFactory.genericRecordFromBytes(bytes, this.schema);
            }
            catch (IOException e) {
                throw new SamzaException("Unable to deserialize the record", (Throwable)e);
            }
            return record;
        }

        public byte[] toBytes(Object o) {
            GenericRecord record = (GenericRecord)o;
            try {
                return AvroSerDeFactory.this.encodeAvroGenericRecord(this.schema, record);
            }
            catch (IOException e) {
                throw new SamzaException("Unable to serialize the record", (Throwable)e);
            }
        }
    }
}

