/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.tools.avro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.reflect.ReflectData;
import org.apache.samza.config.Config;
import org.apache.samza.operators.KV;
import org.apache.samza.sql.avro.AvroRelConverter;
import org.apache.samza.sql.avro.AvroRelSchemaProvider;
import org.apache.samza.sql.data.SamzaSqlRelMessage;
import org.apache.samza.system.SystemStream;

public class AvroSchemaGenRelConverter
extends AvroRelConverter {
    private final String streamName;
    private Map<String, Schema> schemas = new HashMap<String, Schema>();

    public AvroSchemaGenRelConverter(SystemStream systemStream, AvroRelSchemaProvider schemaProvider, Config config) {
        super(systemStream, schemaProvider, config);
        this.streamName = systemStream.getStream();
    }

    public KV<Object, Object> convertToSamzaMessage(SamzaSqlRelMessage relMessage) {
        Schema schema = this.computeSchema(this.streamName, relMessage);
        return this.convertToSamzaMessage(relMessage, schema);
    }

    private Schema computeSchema(String streamName, SamzaSqlRelMessage relMessage) {
        Schema schema;
        ArrayList<Schema.Field> keyFields = new ArrayList<Schema.Field>();
        List fieldNames = relMessage.getSamzaSqlRelRecord().getFieldNames();
        List values = relMessage.getSamzaSqlRelRecord().getFieldValues();
        for (int index = 0; index < fieldNames.size(); ++index) {
            if (((String)fieldNames.get(index)).equals("__key__") || values.get(index) == null) continue;
            Object value = values.get(index);
            Schema avroType = value instanceof GenericData.Record ? ((GenericData.Record)value).getSchema() : ReflectData.get().getSchema(value.getClass());
            keyFields.add(new Schema.Field((String)fieldNames.get(index), avroType, "", null));
        }
        Schema ks = Schema.createRecord((String)streamName, (String)"", (String)(streamName + "_namespace"), (boolean)false);
        ks.setFields(keyFields);
        String schemaStr = ks.toString();
        if (this.schemas.containsKey(schemaStr)) {
            schema = this.schemas.get(schemaStr);
        } else {
            schema = Schema.parse((String)schemaStr);
            this.schemas.put(schemaStr, schema);
        }
        return schema;
    }
}

