/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.tools;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.TaskConfig;
import org.apache.samza.container.grouper.task.SingleContainerGrouperFactory;
import org.apache.samza.serializers.StringSerdeFactory;
import org.apache.samza.sql.avro.ConfigBasedAvroRelSchemaProviderFactory;
import org.apache.samza.sql.fn.FlattenUdf;
import org.apache.samza.sql.fn.RegexMatchUdf;
import org.apache.samza.sql.impl.ConfigBasedIOResolverFactory;
import org.apache.samza.sql.impl.ConfigBasedUdfResolver;
import org.apache.samza.sql.runner.SamzaSqlApplicationRunner;
import org.apache.samza.sql.testutil.JsonUtil;
import org.apache.samza.sql.testutil.SqlFileParser;
import org.apache.samza.standalone.PassthroughJobCoordinatorFactory;
import org.apache.samza.system.kafka.KafkaSystemFactory;
import org.apache.samza.tools.CommandLineHelper;
import org.apache.samza.tools.ConsoleLoggingSystemFactory;
import org.apache.samza.tools.avro.AvroSchemaGenRelConverterFactory;
import org.apache.samza.tools.avro.AvroSerDeFactory;
import org.apache.samza.tools.json.JsonRelConverterFactory;
import org.apache.samza.tools.schemas.PageViewEvent;
import org.apache.samza.tools.schemas.ProfileChangeEvent;

public class SamzaSqlConsole {
    private static final String OPT_SHORT_SQL_FILE = "f";
    private static final String OPT_LONG_SQL_FILE = "file";
    private static final String OPT_ARG_SQL_FILE = "SQL_FILE";
    private static final String OPT_DESC_SQL_FILE = "Path to the SQL file to execute.";
    private static final String OPT_SHORT_SQL_STMT = "s";
    private static final String OPT_LONG_SQL_STMT = "sql";
    private static final String OPT_ARG_SQL_STMT = "SQL_STMT";
    private static final String OPT_DESC_SQL_STMT = "SQL statement to execute.";
    private static final String SAMZA_SYSTEM_KAFKA = "kafka";

    public static void main(String[] args) {
        List<String> sqlStmts;
        CommandLine cmd;
        Options options = new Options();
        options.addOption(CommandLineHelper.createOption(OPT_SHORT_SQL_FILE, OPT_LONG_SQL_FILE, OPT_ARG_SQL_FILE, false, OPT_DESC_SQL_FILE));
        options.addOption(CommandLineHelper.createOption(OPT_SHORT_SQL_STMT, OPT_LONG_SQL_STMT, OPT_ARG_SQL_STMT, false, OPT_DESC_SQL_STMT));
        BasicParser parser = new BasicParser();
        try {
            cmd = parser.parse(options, args);
            if (!cmd.hasOption(OPT_SHORT_SQL_STMT) && !cmd.hasOption(OPT_SHORT_SQL_FILE)) {
                throw new Exception(String.format("One of the (%s or %s) options needs to be set", OPT_SHORT_SQL_FILE, OPT_SHORT_SQL_STMT));
            }
        }
        catch (Exception e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(String.format("Error: %s%nsamza-sql-console.sh", e.getMessage()), options);
            return;
        }
        if (cmd.hasOption(OPT_SHORT_SQL_FILE)) {
            String sqlFile = cmd.getOptionValue(OPT_SHORT_SQL_FILE);
            sqlStmts = SqlFileParser.parseSqlFile((String)sqlFile);
        } else {
            String sql = cmd.getOptionValue(OPT_SHORT_SQL_STMT);
            System.out.println("Executing sql " + sql);
            sqlStmts = Collections.singletonList(sql);
        }
        SamzaSqlConsole.executeSql(sqlStmts);
    }

    public static void executeSql(List<String> sqlStmts) {
        Map<String, String> staticConfigs = SamzaSqlConsole.fetchSamzaSqlConfig();
        staticConfigs.put("samza.sql.stmts.json", JsonUtil.toJson(sqlStmts));
        SamzaSqlApplicationRunner runner = new SamzaSqlApplicationRunner(Boolean.valueOf(true), (Config)new MapConfig(staticConfigs));
        runner.runAndWaitForFinish();
    }

    public static Map<String, String> fetchSamzaSqlConfig() {
        HashMap<String, String> staticConfigs = new HashMap<String, String>();
        staticConfigs.put(JobConfig.JOB_NAME(), "sql-job");
        staticConfigs.put(JobConfig.PROCESSOR_ID(), "1");
        staticConfigs.put("job.coordinator.factory", PassthroughJobCoordinatorFactory.class.getName());
        staticConfigs.put(TaskConfig.GROUPER_FACTORY(), SingleContainerGrouperFactory.class.getName());
        staticConfigs.put("samza.sql.ioResolver", "config");
        String configIOResolverDomain = String.format("samza.sql.ioResolver.%s.", "config");
        staticConfigs.put(configIOResolverDomain + "factory", ConfigBasedIOResolverFactory.class.getName());
        staticConfigs.put("samza.sql.udfResolver", "config");
        String configUdfResolverDomain = String.format("samza.sql.udfResolver.%s.", "config");
        staticConfigs.put(configUdfResolverDomain + "factory", ConfigBasedUdfResolver.class.getName());
        staticConfigs.put(configUdfResolverDomain + "udfClasses", Joiner.on((String)",").join((Object)RegexMatchUdf.class.getName(), (Object)FlattenUdf.class.getName(), new Object[0]));
        staticConfigs.put("serializers.registry.string.class", StringSerdeFactory.class.getName());
        staticConfigs.put("serializers.registry.avro.class", AvroSerDeFactory.class.getName());
        staticConfigs.put(AvroSerDeFactory.CFG_AVRO_SCHEMA, ProfileChangeEvent.SCHEMA$.toString());
        String kafkaSystemConfigPrefix = String.format("systems.%s.", SAMZA_SYSTEM_KAFKA);
        String avroSamzaSqlConfigPrefix = configIOResolverDomain + String.format("%s.", SAMZA_SYSTEM_KAFKA);
        staticConfigs.put(kafkaSystemConfigPrefix + "samza.factory", KafkaSystemFactory.class.getName());
        staticConfigs.put(kafkaSystemConfigPrefix + "samza.key.serde", "string");
        staticConfigs.put(kafkaSystemConfigPrefix + "samza.msg.serde", "avro");
        staticConfigs.put(kafkaSystemConfigPrefix + "consumer.zookeeper.connect", "localhost:2181");
        staticConfigs.put(kafkaSystemConfigPrefix + "producer.bootstrap.servers", "localhost:9092");
        staticConfigs.put(kafkaSystemConfigPrefix + "samza.offset.reset", "true");
        staticConfigs.put(kafkaSystemConfigPrefix + "samza.offset.default", "oldest");
        staticConfigs.put(avroSamzaSqlConfigPrefix + "samzaRelConverterName", "avro");
        staticConfigs.put(avroSamzaSqlConfigPrefix + "relSchemaProviderName", "config");
        String logSystemConfigPrefix = String.format("systems.%s.", "log");
        String logSamzaSqlConfigPrefix = configIOResolverDomain + String.format("%s.", "log");
        staticConfigs.put(logSystemConfigPrefix + "samza.factory", ConsoleLoggingSystemFactory.class.getName());
        staticConfigs.put(logSamzaSqlConfigPrefix + "samzaRelConverterName", "json");
        staticConfigs.put(logSamzaSqlConfigPrefix + "relSchemaProviderName", "config");
        String avroSamzaToRelMsgConverterDomain = String.format("samza.sql.relConverter.%s.", "avro");
        staticConfigs.put(avroSamzaToRelMsgConverterDomain + "factory", AvroSchemaGenRelConverterFactory.class.getName());
        String jsonSamzaToRelMsgConverterDomain = String.format("samza.sql.relConverter.%s.", "json");
        staticConfigs.put(jsonSamzaToRelMsgConverterDomain + "factory", JsonRelConverterFactory.class.getName());
        String configAvroRelSchemaProviderDomain = String.format("samza.sql.relSchemaProvider.%s.", "config");
        staticConfigs.put(configAvroRelSchemaProviderDomain + "factory", ConfigBasedAvroRelSchemaProviderFactory.class.getName());
        staticConfigs.put(configAvroRelSchemaProviderDomain + String.format("%s.%s.schema", SAMZA_SYSTEM_KAFKA, "PageViewStream"), PageViewEvent.SCHEMA$.toString());
        staticConfigs.put(configAvroRelSchemaProviderDomain + String.format("%s.%s.schema", SAMZA_SYSTEM_KAFKA, "ProfileChangeStream"), ProfileChangeEvent.SCHEMA$.toString());
        return staticConfigs;
    }
}

