/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.tools;

import java.util.Random;

public class RandomValueGenerator {
    private String validChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private Random rand;

    public RandomValueGenerator(long seed) {
        this.rand = new Random(seed);
    }

    public int getNextInt() {
        return this.rand.nextInt();
    }

    public int getNextInt(int min, int max) {
        if (max == min) {
            return min;
        }
        return this.rand.nextInt(max - min + 1) + min;
    }

    public String getNextString(int min, int max) {
        int length = this.getNextInt(min, max);
        StringBuilder strbld = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char ch = this.validChars.charAt(this.rand.nextInt(this.validChars.length()));
            strbld.append(ch);
        }
        return strbld.toString();
    }

    public double getNextDouble() {
        return this.rand.nextDouble();
    }

    public float getNextFloat() {
        return this.rand.nextFloat();
    }

    public long getNextLong() {
        long randomLong = this.rand.nextLong();
        return randomLong == Long.MIN_VALUE ? 0L : Math.abs(randomLong);
    }

    public boolean getNextBoolean() {
        return this.rand.nextBoolean();
    }

    public byte[] getNextBytes(int maxBytesLength) {
        byte[] bytes = new byte[this.getNextInt(0, maxBytesLength)];
        this.rand.nextBytes(bytes);
        return bytes;
    }
}

