/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.function.Function;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.samza.tools.CommandLineHelper;
import org.apache.samza.tools.RandomValueGenerator;
import org.apache.samza.tools.schemas.PageViewEvent;
import org.apache.samza.tools.schemas.ProfileChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateKafkaEvents {
    private static final String OPT_SHORT_TOPIC_NAME = "t";
    private static final String OPT_LONG_TOPIC_NAME = "topic";
    private static final String OPT_ARG_TOPIC_NAME = "TOPIC_NAME";
    private static final String OPT_DESC_TOPIC_NAME = "Name of the topic to write events to.";
    private static final String OPT_SHORT_BROKER = "b";
    private static final String OPT_LONG_BROKER = "broker";
    private static final String OPT_ARG_BROKER = "BROKER";
    private static final String OPT_DESC_BROKER = "Kafka broker endpoint.";
    private static final String DEFAULT_BROKER = "localhost:9092";
    private static final String OPT_SHORT_NUM_EVENTS = "n";
    private static final String OPT_LONG_NUM_EVENTS = "numEvents";
    private static final String OPT_ARG_NUM_EVENTS = "NUM_EVENTS";
    private static final String OPT_DESC_NUM_EVENTS = "Number of events to be produced.";
    private static final String OPT_SHORT_EVENT_TYPE = "e";
    private static final String OPT_LONG_EVENT_TYPE = "eventtype";
    private static final String OPT_ARG_EVENT_TYPE = "EVENT_TYPE";
    private static final String OPT_DESC_EVENT_TYPE = "Type of the event (PageView|ProfileChange) Default(ProfileChange).";
    private static final Logger LOG = LoggerFactory.getLogger(GenerateKafkaEvents.class);
    private static RandomValueGenerator randValueGenerator;
    private static String[] companies;
    private static final String PAGEVIEW_EVENTTYPE = "pageview";

    public static void main(String[] args) throws UnsupportedEncodingException, InterruptedException {
        CommandLine cmd;
        randValueGenerator = new RandomValueGenerator(System.currentTimeMillis());
        Options options = new Options();
        options.addOption(CommandLineHelper.createOption(OPT_SHORT_TOPIC_NAME, OPT_LONG_TOPIC_NAME, OPT_ARG_TOPIC_NAME, true, OPT_DESC_TOPIC_NAME));
        options.addOption(CommandLineHelper.createOption(OPT_SHORT_BROKER, OPT_LONG_BROKER, OPT_ARG_BROKER, false, OPT_DESC_BROKER));
        options.addOption(CommandLineHelper.createOption(OPT_SHORT_NUM_EVENTS, OPT_LONG_NUM_EVENTS, OPT_ARG_NUM_EVENTS, false, OPT_DESC_NUM_EVENTS));
        options.addOption(CommandLineHelper.createOption(OPT_SHORT_EVENT_TYPE, OPT_LONG_EVENT_TYPE, OPT_ARG_EVENT_TYPE, false, OPT_DESC_EVENT_TYPE));
        BasicParser parser = new BasicParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (Exception e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(String.format("Error: %s%ngenerate-events.sh", e.getMessage()), options);
            return;
        }
        String topicName = cmd.getOptionValue(OPT_SHORT_TOPIC_NAME);
        String broker = cmd.getOptionValue(OPT_SHORT_BROKER, DEFAULT_BROKER);
        long numEvents = Long.parseLong(cmd.getOptionValue(OPT_SHORT_NUM_EVENTS, String.valueOf(Long.MAX_VALUE)));
        String eventType = cmd.getOptionValue(OPT_SHORT_EVENT_TYPE);
        GenerateKafkaEvents.generateEvents(broker, topicName, eventType, numEvents);
    }

    private static void generateEvents(String brokers, String topicName, String eventType, long numEvents) throws UnsupportedEncodingException, InterruptedException {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokers);
        props.put("retries", (Object)100);
        props.put("batch.size", (Object)16384);
        props.put("key.serializer", ByteArraySerializer.class.getCanonicalName());
        props.put("value.serializer", ByteArraySerializer.class.getCanonicalName());
        Function<Integer, Pair> eventGenerator = eventType.toLowerCase().contains(PAGEVIEW_EVENTTYPE) ? GenerateKafkaEvents::generatePageViewEvent : GenerateKafkaEvents::generateProfileChangeEvent;
        boolean doSleep = false;
        if (numEvents == Long.MAX_VALUE) {
            doSleep = true;
        }
        try (KafkaProducer producer = new KafkaProducer(props);){
            int index = 0;
            while ((long)index < numEvents) {
                boolean finalIndex = false;
                Pair record = eventGenerator.apply(index);
                producer.send(new ProducerRecord(topicName, (Object)((String)record.getLeft()).getBytes("UTF-8"), record.getRight()), (metadata, exception) -> {
                    if (exception != null) {
                        throw new RuntimeException("Failed to send message.", exception);
                    }
                    LOG.info("send completed for event {} at offset {}", (Object)0, (Object)metadata.offset());
                });
                System.out.println(String.format("Published event %d to topic %s", index, topicName));
                if (doSleep) {
                    Thread.sleep(1000L);
                }
                ++index;
            }
            producer.flush();
        }
    }

    private static Pair<String, byte[]> generateProfileChangeEvent(Integer index) {
        byte[] value;
        ProfileChangeEvent event = new ProfileChangeEvent();
        String name = randValueGenerator.getNextString(10, 20);
        event.Name = name;
        event.NewCompany = companies[randValueGenerator.getNextInt(0, companies.length - 1)];
        event.OldCompany = companies[randValueGenerator.getNextInt(0, companies.length - 1)];
        event.ProfileChangeTimestamp = System.currentTimeMillis();
        try {
            value = GenerateKafkaEvents.encodeAvroSpecificRecord(ProfileChangeEvent.class, event);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ImmutablePair((Object)name, (Object)value);
    }

    public static <T> byte[] encodeAvroSpecificRecord(Class<T> clazz, T record) throws IOException {
        SpecificDatumWriter msgDatumWriter = new SpecificDatumWriter(clazz);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)os, null);
        msgDatumWriter.write(record, (Encoder)encoder);
        encoder.flush();
        return os.toByteArray();
    }

    private static Pair<String, byte[]> generatePageViewEvent(int index) {
        byte[] value;
        PageViewEvent event = new PageViewEvent();
        String name = randValueGenerator.getNextString(10, 20);
        event.id = randValueGenerator.getNextInt();
        event.Name = name;
        event.ViewerName = randValueGenerator.getNextString(10, 20);
        event.ProfileViewTimestamp = System.currentTimeMillis();
        try {
            value = GenerateKafkaEvents.encodeAvroSpecificRecord(PageViewEvent.class, event);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ImmutablePair((Object)name, (Object)value);
    }

    static {
        companies = new String[]{"Microsoft", "LinkedIn", "Google", "Facebook", "Amazon", "Apple", "Twitter", "Snap"};
    }
}

