/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.tools;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.NotImplementedException;
import org.apache.samza.Partition;
import org.apache.samza.config.Config;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleLoggingSystemFactory
implements SystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleLoggingSystemFactory.class);
    public static AtomicInteger messageCounter = new AtomicInteger();
    private static ObjectMapper mapper = new ObjectMapper();

    public SystemConsumer getConsumer(String systemName, Config config, MetricsRegistry registry) {
        throw new NotImplementedException();
    }

    public SystemProducer getProducer(String systemName, Config config, MetricsRegistry registry) {
        return new LoggingSystemProducer();
    }

    public SystemAdmin getAdmin(String systemName, Config config) {
        return new SimpleSystemAdmin(config);
    }

    public static class SimpleSystemAdmin
    implements SystemAdmin {
        public SimpleSystemAdmin(Config config) {
        }

        public Map<SystemStreamPartition, String> getOffsetsAfter(Map<SystemStreamPartition, String> offsets) {
            return offsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, null));
        }

        public Map<String, SystemStreamMetadata> getSystemStreamMetadata(Set<String> streamNames) {
            return streamNames.stream().collect(Collectors.toMap(Function.identity(), streamName -> new SystemStreamMetadata(streamName, Collections.singletonMap(new Partition(0), new SystemStreamMetadata.SystemStreamPartitionMetadata(null, null, null)))));
        }

        public Integer offsetComparator(String offset1, String offset2) {
            if (offset1 == null) {
                return offset2 == null ? 0 : -1;
            }
            if (offset2 == null) {
                return 1;
            }
            return offset1.compareTo(offset2);
        }
    }

    private class LoggingSystemProducer
    implements SystemProducer {
        private LoggingSystemProducer() {
        }

        public void start() {
        }

        public void stop() {
        }

        public void register(String source) {
            LOG.info("Registering source" + source);
        }

        public void send(String source, OutgoingMessageEnvelope envelope) {
            String msg = String.format("OutputStream:%s Key:%s Value:%s", envelope.getSystemStream(), envelope.getKey(), new String((byte[])envelope.getMessage()));
            LOG.info(msg);
            System.out.println(String.format("Message %d :", messageCounter.incrementAndGet()));
            if (envelope.getKey() != null) {
                System.out.println(String.format("Key:%s Value:%s", envelope.getKey(), this.getFormattedValue(envelope)));
            } else {
                System.out.println(this.getFormattedValue(envelope));
            }
        }

        private String getFormattedValue(OutgoingMessageEnvelope envelope) {
            String formattedValue;
            String value = new String((byte[])envelope.getMessage());
            try {
                Object json = mapper.readValue(value, Object.class);
                formattedValue = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
            }
            catch (IOException e) {
                formattedValue = value;
                LOG.error("Error while formatting json", (Throwable)e);
            }
            return formattedValue;
        }

        public void flush(String source) {
        }
    }
}

