/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv.inmemory.descriptors;

import java.util.HashMap;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.config.StorageConfig;
import org.apache.samza.storage.kv.descriptors.BaseLocalStoreBackedTableProvider;
import org.apache.samza.storage.kv.inmemory.InMemoryKeyValueStorageEngineFactory;
import org.apache.samza.table.TableSpec;

public class InMemoryTableProvider
extends BaseLocalStoreBackedTableProvider {
    public InMemoryTableProvider(TableSpec tableSpec) {
        super(tableSpec);
    }

    public Map<String, String> generateConfig(Config jobConfig, Map<String, String> generatedConfig) {
        HashMap<String, String> tableConfig = new HashMap<String, String>();
        tableConfig.put(String.format(StorageConfig.FACTORY(), this.tableSpec.getId()), InMemoryKeyValueStorageEngineFactory.class.getName());
        tableConfig.putAll(this.generateCommonStoreConfig(jobConfig, generatedConfig));
        this.tableSpec.getConfig().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("internal.")).forEach(e -> {
            String k = (String)e.getKey();
            String v = (String)e.getValue();
            String realKey = k.startsWith("inmemory.") ? String.format("stores.%s", this.tableSpec.getId()) + "." + k.substring("inmemory.".length()) : String.format("tables.%s", this.tableSpec.getId()) + "." + k;
            tableConfig.put(realKey, v);
        });
        this.logger.info("Generated configuration for table " + this.tableSpec.getId());
        return tableConfig;
    }
}

