/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.table.CloudTable;
import com.microsoft.azure.storage.table.CloudTableClient;
import com.microsoft.azure.storage.table.TableEntity;
import com.microsoft.azure.storage.table.TableOperation;
import com.microsoft.azure.storage.table.TableQuery;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.samza.AzureClient;
import org.apache.samza.AzureException;
import org.apache.samza.coordinator.data.ProcessorEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TableUtils.class);
    private static final String PARTITION_KEY = "PartitionKey";
    private static final long LIVENESS_DEBOUNCE_TIME_SEC = 30L;
    private final String initialState;
    private final CloudTable table;

    public TableUtils(AzureClient client, String tableName, String initialState) {
        this.initialState = initialState;
        CloudTableClient tableClient = client.getTableClient();
        try {
            this.table = tableClient.getTableReference(tableName);
            this.table.createIfNotExists();
        }
        catch (URISyntaxException e) {
            LOG.error("\nConnection string specifies an invalid URI.", (Throwable)e);
            throw new AzureException(e);
        }
        catch (StorageException e) {
            LOG.error("Azure storage exception.", (Throwable)e);
            throw new AzureException(e);
        }
    }

    public void addProcessorEntity(String jmVersion, String pid, boolean isLeader) {
        ProcessorEntity entity = new ProcessorEntity(jmVersion, pid);
        entity.setIsLeader(isLeader);
        entity.updateLiveness();
        TableOperation add = TableOperation.insert((TableEntity)entity);
        try {
            this.table.execute(add);
        }
        catch (StorageException e) {
            LOG.error("Azure storage exception while adding processor entity with job model version: " + jmVersion + "and pid: " + pid, (Throwable)e);
            throw new AzureException(e);
        }
    }

    public ProcessorEntity getEntity(String jmVersion, String pid) {
        try {
            TableOperation retrieveEntity = TableOperation.retrieve((String)jmVersion, (String)pid, ProcessorEntity.class);
            return (ProcessorEntity)((Object)this.table.execute(retrieveEntity).getResultAsType());
        }
        catch (StorageException e) {
            LOG.error("Azure storage exception while retrieving processor entity with job model version: " + jmVersion + "and pid: " + pid, (Throwable)e);
            throw new AzureException(e);
        }
    }

    public void updateHeartbeat(String jmVersion, String pid) {
        try {
            TableOperation retrieveEntity = TableOperation.retrieve((String)jmVersion, (String)pid, ProcessorEntity.class);
            ProcessorEntity entity = (ProcessorEntity)((Object)this.table.execute(retrieveEntity).getResultAsType());
            entity.updateLiveness();
            TableOperation update = TableOperation.replace((TableEntity)entity);
            this.table.execute(update);
        }
        catch (StorageException e) {
            LOG.error("Azure storage exception while updating heartbeat for job model version: " + jmVersion + "and pid: " + pid, (Throwable)e);
        }
    }

    public void updateIsLeader(String jmVersion, String pid, boolean isLeader) {
        try {
            TableOperation retrieveEntity = TableOperation.retrieve((String)jmVersion, (String)pid, ProcessorEntity.class);
            ProcessorEntity entity = (ProcessorEntity)((Object)this.table.execute(retrieveEntity).getResultAsType());
            entity.setIsLeader(isLeader);
            TableOperation update = TableOperation.replace((TableEntity)entity);
            this.table.execute(update);
        }
        catch (StorageException e) {
            LOG.error("Azure storage exception while updating isLeader value for job model version: " + jmVersion + "and pid: " + pid, (Throwable)e);
            throw new AzureException(e);
        }
    }

    public void deleteProcessorEntity(String jmVersion, String pid, boolean force) {
        try {
            TableOperation retrieveEntity = TableOperation.retrieve((String)jmVersion, (String)pid, ProcessorEntity.class);
            ProcessorEntity entity = (ProcessorEntity)((Object)this.table.execute(retrieveEntity).getResultAsType());
            if (force) {
                entity.setEtag("*");
            }
            TableOperation remove = TableOperation.delete((TableEntity)entity);
            this.table.execute(remove);
        }
        catch (StorageException e) {
            LOG.error("Azure storage exception while deleting processor entity with job model version: " + jmVersion + "and pid: " + pid, (Throwable)e);
            throw new AzureException(e);
        }
    }

    public void deleteProcessorEntity(ProcessorEntity entity) {
        try {
            TableOperation remove = TableOperation.delete((TableEntity)entity);
            this.table.execute(remove);
        }
        catch (StorageException e) {
            LOG.error("Azure storage exception while deleting processor entity with job model version: " + entity.getJobModelVersion() + "and pid: " + entity.getProcessorId(), (Throwable)e);
            throw new AzureException(e);
        }
    }

    public Iterable<ProcessorEntity> getEntitiesWithPartition(String partitionKey) {
        String partitionFilter = TableQuery.generateFilterCondition((String)PARTITION_KEY, (String)"eq", (String)partitionKey);
        TableQuery partitionQuery = TableQuery.from(ProcessorEntity.class).where(partitionFilter);
        return this.table.execute(partitionQuery);
    }

    public Set<String> getActiveProcessorsList(AtomicReference<String> currentJMVersion) {
        Iterable<ProcessorEntity> tableList = this.getEntitiesWithPartition(currentJMVersion.get());
        HashSet<String> activeProcessorsList = new HashSet<String>();
        for (ProcessorEntity entity : tableList) {
            if (System.currentTimeMillis() - entity.getTimestamp().getTime() > 30000L) continue;
            activeProcessorsList.add(entity.getRowKey());
        }
        Iterable<ProcessorEntity> unassignedList = this.getEntitiesWithPartition(this.initialState);
        for (ProcessorEntity entity : unassignedList) {
            long temp = System.currentTimeMillis() - entity.getTimestamp().getTime();
            LOG.info("Time elapsed since last heartbeat: {}", (Object)temp);
            if (temp > 30000L) continue;
            activeProcessorsList.add(entity.getRowKey());
        }
        LOG.info("Active processors list: {}", activeProcessorsList);
        return activeProcessorsList;
    }

    public CloudTable getTable() {
        return this.table;
    }
}

