/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudPageBlob;
import org.apache.samza.AzureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseBlobManager {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseBlobManager.class);
    private final CloudPageBlob leaseBlob;

    public LeaseBlobManager(CloudPageBlob leaseBlob) {
        this.leaseBlob = leaseBlob;
    }

    public String acquireLease(int leaseTimeInSec, String leaseId) {
        try {
            String id = this.leaseBlob.acquireLease(Integer.valueOf(leaseTimeInSec), leaseId);
            LOG.info("Acquired lease with lease id = " + id);
            return id;
        }
        catch (StorageException storageException) {
            int httpStatusCode = storageException.getHttpStatusCode();
            if (httpStatusCode != 409) {
                if (httpStatusCode == 404) {
                    LOG.error("The blob you're trying to lease does not exist.", (Throwable)storageException);
                    throw new AzureException(storageException);
                }
                LOG.error("Error acquiring lease!", (Throwable)storageException);
                throw new AzureException(storageException);
            }
            LOG.info("The blob you're trying to acquire is leased already.", (Object)storageException.getMessage());
            return null;
        }
    }

    public boolean renewLease(String leaseId) {
        try {
            this.leaseBlob.renewLease(AccessCondition.generateLeaseCondition((String)leaseId));
            return true;
        }
        catch (StorageException storageException) {
            LOG.error("Wasn't able to renew lease with lease id: " + leaseId, (Throwable)storageException);
            return false;
        }
    }

    public boolean releaseLease(String leaseId) {
        try {
            this.leaseBlob.releaseLease(AccessCondition.generateLeaseCondition((String)leaseId));
            return true;
        }
        catch (StorageException storageException) {
            LOG.error("Wasn't able to release lease with lease id: " + leaseId, (Throwable)storageException);
            return false;
        }
    }
}

