/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.util;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudPageBlob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.apache.samza.AzureClient;
import org.apache.samza.AzureException;
import org.apache.samza.SamzaException;
import org.apache.samza.coordinator.data.JobModelBundle;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.serializers.model.SamzaObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BlobUtils.class);
    private static final long JOB_MODEL_BLOCK_SIZE = 1024000L;
    private static final long BARRIER_STATE_BLOCK_SIZE = 1024L;
    private static final long PROCESSOR_LIST_BLOCK_SIZE = 1024L;
    private CloudBlobClient blobClient;
    private CloudBlobContainer container;
    private CloudPageBlob blob;

    public BlobUtils(AzureClient client, String containerName, String blobName, long length) {
        this.blobClient = client.getBlobClient();
        try {
            this.container = this.blobClient.getContainerReference(containerName);
            this.container.createIfNotExists();
            this.blob = this.container.getPageBlobReference(blobName);
            if (!this.blob.exists()) {
                this.blob.create(length, AccessCondition.generateIfNotExistsCondition(), null, null);
            }
        }
        catch (URISyntaxException e) {
            LOG.error("Container name: " + containerName + " or blob name: " + blobName + " invalid.", (Throwable)e);
            throw new AzureException(e);
        }
        catch (StorageException e) {
            int httpStatusCode = e.getHttpStatusCode();
            if (httpStatusCode == 409) {
                LOG.info("The blob you're trying to create exists already.", (Throwable)e);
            }
            LOG.error("Azure Storage Exception!", (Throwable)e);
            throw new AzureException(e);
        }
    }

    public boolean publishJobModel(JobModel prevJM, JobModel currJM, String prevJMV, String currJMV, String leaseId) {
        try {
            if (leaseId == null) {
                return false;
            }
            JobModelBundle bundle = new JobModelBundle(prevJM, currJM, prevJMV, currJMV);
            byte[] data = SamzaObjectMapper.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)bundle);
            byte[] pageData = Arrays.copyOf(data, 1024000);
            ByteArrayInputStream is = new ByteArrayInputStream(pageData);
            this.blob.uploadPages((InputStream)is, 0L, 1024000L, AccessCondition.generateLeaseCondition((String)leaseId), null, null);
            LOG.info("Uploaded {} jobModel to blob", (Object)bundle.getCurrJobModel());
            return true;
        }
        catch (StorageException | IOException e) {
            LOG.error("JobModel publish failed for version = " + currJMV, e);
            return false;
        }
    }

    public JobModel getJobModel() {
        LOG.info("Reading the job model from blob.");
        JobModelBundle jmBundle = this.getJobModelBundle();
        if (jmBundle == null) {
            LOG.error("Job Model details don't exist on the blob.");
            return null;
        }
        JobModel jm = jmBundle.getCurrJobModel();
        return jm;
    }

    public String getJobModelVersion() {
        LOG.info("Reading the job model version from blob.");
        JobModelBundle jmBundle = this.getJobModelBundle();
        if (jmBundle == null) {
            LOG.error("Job Model details don't exist on the blob.");
            return null;
        }
        String jmVersion = jmBundle.getCurrJobModelVersion();
        return jmVersion;
    }

    public boolean publishBarrierState(String state, String leaseId) {
        try {
            if (leaseId == null) {
                return false;
            }
            byte[] data = SamzaObjectMapper.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)state);
            byte[] pageData = Arrays.copyOf(data, 1024);
            ByteArrayInputStream is = new ByteArrayInputStream(pageData);
            this.blob.uploadPages((InputStream)is, 1024000L, 1024L, AccessCondition.generateLeaseCondition((String)leaseId), null, null);
            LOG.info("Uploaded barrier state {} to blob", (Object)state);
            return true;
        }
        catch (StorageException | IOException e) {
            LOG.error("Barrier state " + state + " publish failed", e);
            return false;
        }
    }

    public String getBarrierState() {
        String state;
        LOG.info("Reading the barrier state from blob.");
        byte[] data = new byte[1024];
        try {
            this.blob.downloadRangeToByteArray(1024000L, Long.valueOf(1024L), data, 0);
        }
        catch (StorageException e) {
            LOG.error("Failed to read barrier state from blob.", (Throwable)e);
            throw new AzureException(e);
        }
        try {
            state = (String)SamzaObjectMapper.getObjectMapper().readValue(data, String.class);
        }
        catch (IOException e) {
            LOG.error("Failed to parse byte data: " + data + " for barrier state retrieved from the blob.", (Throwable)e);
            throw new SamzaException((Throwable)e);
        }
        return state;
    }

    public boolean publishLiveProcessorList(List<String> processors, String leaseId) {
        try {
            if (leaseId == null) {
                return false;
            }
            byte[] data = SamzaObjectMapper.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes(processors);
            byte[] pageData = Arrays.copyOf(data, 1024);
            ByteArrayInputStream is = new ByteArrayInputStream(pageData);
            this.blob.uploadPages((InputStream)is, 1025024L, 1024L, AccessCondition.generateLeaseCondition((String)leaseId), null, null);
            LOG.info("Uploaded list of live processors to blob.");
            return true;
        }
        catch (StorageException | IOException e) {
            LOG.error("Processor list: " + processors + "publish failed", e);
            return false;
        }
    }

    public List<String> getLiveProcessorList() {
        List list;
        LOG.info("Read the the list of live processors from blob.");
        byte[] data = new byte[1024];
        try {
            this.blob.downloadRangeToByteArray(1025024L, Long.valueOf(1024L), data, 0);
        }
        catch (StorageException e) {
            LOG.error("Failed to read the list of live processors from the blob.", (Throwable)new AzureException(e));
            throw new AzureException(e);
        }
        try {
            list = (List)SamzaObjectMapper.getObjectMapper().readValue(data, List.class);
        }
        catch (IOException e) {
            LOG.error("Failed to parse byte data: " + data + " for live processor list retrieved from the blob", (Throwable)new SamzaException((Throwable)e));
            throw new SamzaException((Throwable)e);
        }
        return list;
    }

    public CloudBlobClient getBlobClient() {
        return this.blobClient;
    }

    public CloudBlobContainer getBlobContainer() {
        return this.container;
    }

    public CloudPageBlob getBlob() {
        return this.blob;
    }

    private JobModelBundle getJobModelBundle() {
        byte[] data = new byte[1024000];
        try {
            this.blob.downloadRangeToByteArray(0L, Long.valueOf(1024000L), data, 0);
        }
        catch (StorageException e) {
            LOG.error("Failed to read JobModel details from the blob.", (Throwable)e);
            throw new AzureException(e);
        }
        try {
            JobModelBundle jmBundle = (JobModelBundle)SamzaObjectMapper.getObjectMapper().readValue(data, JobModelBundle.class);
            return jmBundle;
        }
        catch (IOException e) {
            LOG.error("Failed to parse byte data: " + data + " for JobModel details retrieved from the blob", (Throwable)e);
            throw new SamzaException((Throwable)e);
        }
    }
}

