/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.eventhub.producer;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.EventHubRuntimeInformation;
import com.microsoft.azure.eventhubs.PartitionSender;
import com.microsoft.azure.eventhubs.impl.EventDataImpl;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.Validate;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.eventhub.EventHubClientManager;
import org.apache.samza.system.eventhub.EventHubClientManagerFactory;
import org.apache.samza.system.eventhub.EventHubConfig;
import org.apache.samza.system.eventhub.Interceptor;
import org.apache.samza.system.eventhub.producer.AsyncSystemProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubSystemProducer
extends AsyncSystemProducer {
    private static final Logger LOG = LoggerFactory.getLogger((String)EventHubSystemProducer.class.getName());
    private static final long DEFAULT_SHUTDOWN_TIMEOUT_MILLIS = Duration.ofMinutes(1L).toMillis();
    public static final String PRODUCE_TIMESTAMP = "produce-timestamp";
    public static final String KEY = "key";
    private static final String EVENT_SKIP_RATE = "eventSkipRate";
    private static final String EVENT_WRITE_RATE = "eventWriteRate";
    private static final String EVENT_BYTE_WRITE_RATE = "eventByteWriteRate";
    private static final Object AGGREGATE_METRICS_LOCK = new Object();
    private final HashMap<String, Counter> eventSkipRate = new HashMap();
    private final HashMap<String, Counter> eventWriteRate = new HashMap();
    private final HashMap<String, Counter> eventByteWriteRate = new HashMap();
    private static Counter aggEventSkipRate = null;
    private static Counter aggEventWriteRate = null;
    private static Counter aggEventByteWriteRate = null;
    private final EventHubConfig config;
    private final PartitioningMethod partitioningMethod;
    private final String systemName;
    private final int maxMessageSize;
    private volatile boolean isStarted = false;
    private boolean isInitialized = false;
    @VisibleForTesting
    final Map<String, Map<Integer, EventHubClientManager>> perPartitionEventHubClients = new HashMap<String, Map<Integer, EventHubClientManager>>();
    private final Map<String, EventHubClientManager> perStreamEventHubClientManagers = new HashMap<String, EventHubClientManager>();
    private final Map<String, Map<Integer, PartitionSender>> streamPartitionSenders = new HashMap<String, Map<Integer, PartitionSender>>();
    private final Map<String, Interceptor> interceptors;
    private final EventHubClientManagerFactory eventHubClientManagerFactory;

    public EventHubSystemProducer(EventHubConfig config, String systemName, EventHubClientManagerFactory eventHubClientManagerFactory, Map<String, Interceptor> interceptors, MetricsRegistry registry) {
        super(systemName, (Config)config, registry);
        LOG.info("Creating EventHub Producer for system {}", (Object)systemName);
        this.config = config;
        this.systemName = systemName;
        this.partitioningMethod = config.getPartitioningMethod(systemName);
        this.interceptors = interceptors;
        this.maxMessageSize = config.getSkipMessagesLargerThan(systemName);
        this.eventHubClientManagerFactory = eventHubClientManagerFactory;
    }

    private void init() {
        LOG.info("Initializing EventHubSystemProducer");
        List<String> streamIds = this.config.getStreams(this.systemName);
        for (String streamId2 : streamIds) {
            EventHubClientManager ehClient = this.eventHubClientManagerFactory.getEventHubClientManager(this.systemName, streamId2, this.config);
            this.perStreamEventHubClientManagers.put(streamId2, ehClient);
            ehClient.init();
        }
        if (PartitioningMethod.PARTITION_KEY_AS_PARTITION.equals((Object)this.partitioningMethod)) {
            this.perStreamEventHubClientManagers.forEach((streamId, samzaEventHubClient) -> {
                EventHubClient ehClient = samzaEventHubClient.getEventHubClient();
                try {
                    HashMap<Integer, PartitionSender> partitionSenders = new HashMap<Integer, PartitionSender>();
                    long timeoutMs = this.config.getRuntimeInfoWaitTimeMS(this.systemName);
                    Integer numPartitions = ((EventHubRuntimeInformation)ehClient.getRuntimeInformation().get(timeoutMs, TimeUnit.MILLISECONDS)).getPartitionCount();
                    for (int i = 0; i < numPartitions; ++i) {
                        String partitionId = String.valueOf(i);
                        EventHubClientManager perPartitionClientManager = this.createOrGetEventHubClientManagerForPartition((String)streamId, i);
                        PartitionSender partitionSender = perPartitionClientManager.getEventHubClient().createPartitionSenderSync(partitionId);
                        partitionSenders.put(i, partitionSender);
                    }
                    this.streamPartitionSenders.put((String)streamId, (Map<Integer, PartitionSender>)partitionSenders);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    String msg = "Failed to fetch number of Event Hub partitions for partition sender creation";
                    throw new SamzaException(msg, (Throwable)e);
                }
                catch (EventHubException | IllegalArgumentException e) {
                    String msg = "Creation of partition sender failed with exception";
                    throw new SamzaException(msg, e);
                }
            });
        }
        this.isInitialized = true;
        LOG.info("EventHubSystemProducer initialized.");
    }

    public synchronized void register(String source) {
        LOG.info("Registering source {}", (Object)source);
        if (this.isStarted) {
            String msg = "Cannot register once the producer is started.";
            throw new SamzaException(msg);
        }
    }

    private EventHubClientManager createOrGetEventHubClientManagerForPartition(String streamId, int partitionId) {
        EventHubClientManager eventHubClientManager;
        Map perStreamMap = this.perPartitionEventHubClients.computeIfAbsent(streamId, key -> new HashMap());
        if (this.config.getPerPartitionConnection(this.systemName).booleanValue()) {
            if (perStreamMap.containsKey(partitionId)) {
                LOG.warn(String.format("Trying to create new EventHubClientManager for partition=%d. But one already exists", partitionId));
                eventHubClientManager = (EventHubClientManager)perStreamMap.get(partitionId);
            } else {
                LOG.info(String.format("Creating EventHub client manager for streamId=%s, partitionId=%d: ", streamId, partitionId));
                eventHubClientManager = this.eventHubClientManagerFactory.getEventHubClientManager(this.systemName, streamId, this.config);
                eventHubClientManager.init();
                perStreamMap.put(partitionId, eventHubClientManager);
            }
        } else {
            eventHubClientManager = this.perStreamEventHubClientManagers.get(streamId);
            perStreamMap.put(partitionId, eventHubClientManager);
        }
        Validate.notNull((Object)eventHubClientManager, (String)String.format("Fail to create or get EventHubClientManager for streamId=%s, partitionId=%d", streamId, partitionId), (Object[])new Object[0]);
        return eventHubClientManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        super.start();
        LOG.info("Starting system producer.");
        this.streamIds.forEach(streamId -> {
            this.eventSkipRate.put((String)streamId, this.metricsRegistry.newCounter(streamId, EVENT_SKIP_RATE));
            this.eventWriteRate.put((String)streamId, this.metricsRegistry.newCounter(streamId, EVENT_WRITE_RATE));
            this.eventByteWriteRate.put((String)streamId, this.metricsRegistry.newCounter(streamId, EVENT_BYTE_WRITE_RATE));
        });
        Object object = AGGREGATE_METRICS_LOCK;
        synchronized (object) {
            if (aggEventWriteRate == null) {
                aggEventSkipRate = this.metricsRegistry.newCounter("aggregate", EVENT_SKIP_RATE);
                aggEventWriteRate = this.metricsRegistry.newCounter("aggregate", EVENT_WRITE_RATE);
                aggEventByteWriteRate = this.metricsRegistry.newCounter("aggregate", EVENT_BYTE_WRITE_RATE);
            }
        }
        this.isStarted = true;
    }

    @Override
    public synchronized void flush(String source) {
        super.flush(source);
    }

    @Override
    public synchronized CompletableFuture<Void> sendAsync(String source, OutgoingMessageEnvelope envelope) {
        int eventDataLength;
        String streamId;
        LOG.debug(String.format("Trying to send %s", envelope));
        if (!this.isStarted) {
            throw new SamzaException("Trying to call send before the producer is started.");
        }
        if (!this.isInitialized) {
            this.init();
        }
        if (!this.perStreamEventHubClientManagers.containsKey(streamId = this.config.getStreamId(envelope.getSystemStream().getStream()))) {
            String msg = String.format("Trying to send event to a destination {%s} that is not registered.", streamId);
            throw new SamzaException(msg);
        }
        EventData eventData = this.createEventData(streamId, envelope);
        int n = eventDataLength = eventData.getBytes() == null ? 0 : eventData.getBytes().length;
        if (this.maxMessageSize > 0 && eventDataLength > this.maxMessageSize) {
            LOG.info("Received a message with size {} > maxMessageSize configured {(}), Skipping it", (Object)eventDataLength, (Object)this.maxMessageSize);
            this.eventSkipRate.get(streamId).inc();
            aggEventSkipRate.inc();
            return CompletableFuture.completedFuture(null);
        }
        this.eventWriteRate.get(streamId).inc();
        aggEventWriteRate.inc();
        this.eventByteWriteRate.get(streamId).inc((long)eventDataLength);
        aggEventByteWriteRate.inc((long)eventDataLength);
        EventHubClientManager ehClient = this.perStreamEventHubClientManagers.get(streamId);
        return this.sendToEventHub(streamId, eventData, this.getEnvelopePartitionId(envelope), ehClient.getEventHubClient());
    }

    private CompletableFuture<Void> sendToEventHub(String streamId, EventData eventData, Object partitionKey, EventHubClient eventHubClient) {
        if (PartitioningMethod.ROUND_ROBIN.equals((Object)this.partitioningMethod)) {
            return eventHubClient.send(eventData);
        }
        if (PartitioningMethod.EVENT_HUB_HASHING.equals((Object)this.partitioningMethod)) {
            if (partitionKey == null) {
                throw new SamzaException("Partition key cannot be null for EventHub hashing");
            }
            return eventHubClient.send(eventData, this.convertPartitionKeyToString(partitionKey));
        }
        if (PartitioningMethod.PARTITION_KEY_AS_PARTITION.equals((Object)this.partitioningMethod)) {
            if (!(partitionKey instanceof Integer)) {
                String msg = "Partition key should be of type Integer";
                throw new SamzaException(msg);
            }
            Integer numPartition = this.streamPartitionSenders.get(streamId).size();
            Integer destinationPartition = (Integer)partitionKey % numPartition;
            PartitionSender sender = this.streamPartitionSenders.get(streamId).get(destinationPartition);
            return sender.send(eventData);
        }
        throw new SamzaException("Unknown partitioning method " + (Object)((Object)this.partitioningMethod));
    }

    protected Object getEnvelopePartitionId(OutgoingMessageEnvelope envelope) {
        return envelope.getPartitionKey() == null ? envelope.getKey() : envelope.getPartitionKey();
    }

    private String convertPartitionKeyToString(Object partitionKey) {
        String partitionKeyStr;
        if (partitionKey instanceof String) {
            partitionKeyStr = (String)partitionKey;
        } else if (partitionKey instanceof Integer) {
            partitionKeyStr = String.valueOf(partitionKey);
        } else if (partitionKey instanceof byte[]) {
            partitionKeyStr = new String((byte[])partitionKey, Charset.defaultCharset());
        } else {
            throw new SamzaException("Unsupported key type: " + partitionKey.getClass().toString());
        }
        if (partitionKeyStr != null && partitionKeyStr.length() > 128) {
            LOG.debug("Length of partition key: {} exceeds limit: {}. Truncating.", (Object)partitionKeyStr.length(), (Object)128);
            partitionKeyStr = partitionKeyStr.substring(0, 128);
        }
        return partitionKeyStr;
    }

    protected EventData createEventData(String streamId, OutgoingMessageEnvelope envelope) {
        Optional<Object> interceptor = Optional.ofNullable(this.interceptors.getOrDefault(streamId, null));
        byte[] eventValue = (byte[])envelope.getMessage();
        if (interceptor.isPresent()) {
            eventValue = ((Interceptor)interceptor.get()).intercept(eventValue);
        }
        EventDataImpl eventData = new EventDataImpl(eventValue);
        eventData.getProperties().put(PRODUCE_TIMESTAMP, Long.toString(System.currentTimeMillis()));
        if (this.config.getSendKeyInEventProperties(this.systemName).booleanValue()) {
            String keyValue = "";
            if (envelope.getKey() != null) {
                keyValue = envelope.getKey() instanceof byte[] ? new String((byte[])envelope.getKey()) : envelope.getKey().toString();
            }
            eventData.getProperties().put(KEY, keyValue);
        }
        return eventData;
    }

    public synchronized void stop() {
        LOG.info("Stopping producer.");
        this.streamPartitionSenders.values().forEach(streamPartitionSender -> {
            ArrayList futures = new ArrayList();
            streamPartitionSender.forEach((key, value) -> futures.add(value.close()));
            CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
            try {
                future.get(DEFAULT_SHUTDOWN_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOG.error("Closing the partition sender failed ", (Throwable)e);
            }
        });
        this.perStreamEventHubClientManagers.values().parallelStream().forEach(ehClient -> ehClient.close(DEFAULT_SHUTDOWN_TIMEOUT_MILLIS));
        this.perStreamEventHubClientManagers.clear();
        if (this.config.getPerPartitionConnection(this.systemName).booleanValue()) {
            this.perPartitionEventHubClients.values().stream().flatMap(map -> map.values().stream()).forEach(ehClient -> ehClient.close(DEFAULT_SHUTDOWN_TIMEOUT_MILLIS));
            this.perPartitionEventHubClients.clear();
        }
        this.isStarted = false;
        this.isInitialized = false;
        LOG.info("EventHubSystemProducer stopped.");
    }

    Collection<CompletableFuture<Void>> getPendingFutures() {
        return this.pendingFutures;
    }

    public static enum PartitioningMethod {
        ROUND_ROBIN,
        EVENT_HUB_HASHING,
        PARTITION_KEY_AS_PARTITION;

    }
}

