/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.eventhub.producer;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.eventhub.metrics.SamzaHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncSystemProducer
implements SystemProducer {
    private static final Logger LOG = LoggerFactory.getLogger((String)AsyncSystemProducer.class.getName());
    private static final long DEFAULT_FLUSH_TIMEOUT_MILLIS = Duration.ofMinutes(1L).toMillis();
    public static final String CONFIG_STREAM_LIST = "systems.%s.stream.list";
    private static final String SEND_ERRORS = "sendErrors";
    private static final String SEND_CALLBACK_LATENCY = "sendCallbackLatency";
    private static final String SEND_LATENCY = "sendLatency";
    protected static final String AGGREGATE = "aggregate";
    protected final List<String> streamIds;
    protected final Map<String, String> physicalToStreamIds;
    protected final MetricsRegistry metricsRegistry;
    protected final Set<CompletableFuture<Void>> pendingFutures = ConcurrentHashMap.newKeySet();
    private final AtomicReference<Throwable> sendExceptionOnCallback = new AtomicReference<Object>(null);
    private static Counter aggSendErrors = null;
    private static SamzaHistogram aggSendLatency = null;
    private static SamzaHistogram aggSendCallbackLatency = null;
    private final HashMap<String, SamzaHistogram> sendLatency = new HashMap();
    private final HashMap<String, SamzaHistogram> sendCallbackLatency = new HashMap();
    private final HashMap<String, Counter> sendErrors = new HashMap();

    public AsyncSystemProducer(String systemName, Config config, MetricsRegistry metricsRegistry) {
        StreamConfig sconfig = new StreamConfig(config);
        this.streamIds = config.getList(String.format(CONFIG_STREAM_LIST, systemName));
        this.physicalToStreamIds = this.streamIds.stream().collect(Collectors.toMap(arg_0 -> ((StreamConfig)sconfig).getPhysicalName(arg_0), Function.identity()));
        this.metricsRegistry = metricsRegistry;
    }

    public synchronized void send(String source, OutgoingMessageEnvelope envelope) {
        this.checkForSendCallbackErrors("Received exception on message send");
        String streamName = envelope.getSystemStream().getStream();
        String streamId = this.physicalToStreamIds.getOrDefault(streamName, streamName);
        long beforeSendTimeMs = System.currentTimeMillis();
        CompletableFuture<Void> sendResult = this.sendAsync(source, envelope);
        long afterSendTimeMs = System.currentTimeMillis();
        long latencyMs = afterSendTimeMs - beforeSendTimeMs;
        this.sendLatency.get(streamId).update(latencyMs);
        aggSendLatency.update(latencyMs);
        this.pendingFutures.add(sendResult);
        sendResult.handle((aVoid, throwable) -> {
            long callbackLatencyMs = System.currentTimeMillis() - afterSendTimeMs;
            this.sendCallbackLatency.get(streamId).update(callbackLatencyMs);
            aggSendCallbackLatency.update(callbackLatencyMs);
            if (throwable != null) {
                this.sendErrors.get(streamId).inc();
                aggSendErrors.inc();
                LOG.error("Send message to event hub: {} failed with exception: ", (Object)streamId, throwable);
                this.sendExceptionOnCallback.compareAndSet((Throwable)null, (Throwable)throwable);
            }
            return aVoid;
        });
    }

    public void start() {
        this.streamIds.forEach(streamId -> {
            this.sendCallbackLatency.put((String)streamId, new SamzaHistogram(this.metricsRegistry, (String)streamId, SEND_CALLBACK_LATENCY));
            this.sendLatency.put((String)streamId, new SamzaHistogram(this.metricsRegistry, (String)streamId, SEND_LATENCY));
            this.sendErrors.put((String)streamId, this.metricsRegistry.newCounter(streamId, SEND_ERRORS));
        });
        if (aggSendLatency == null) {
            aggSendLatency = new SamzaHistogram(this.metricsRegistry, AGGREGATE, SEND_LATENCY);
            aggSendCallbackLatency = new SamzaHistogram(this.metricsRegistry, AGGREGATE, SEND_CALLBACK_LATENCY);
            aggSendErrors = this.metricsRegistry.newCounter(AGGREGATE, SEND_ERRORS);
        }
    }

    public synchronized void flush(String source) {
        long incompleteSends = this.pendingFutures.stream().filter(x -> !x.isDone()).count();
        LOG.info("Trying to flush pending {} sends.", (Object)incompleteSends);
        this.checkForSendCallbackErrors("Received exception on message send.");
        CompletableFuture<Void> future = CompletableFuture.allOf(this.pendingFutures.toArray(new CompletableFuture[this.pendingFutures.size()]));
        try {
            future.get(DEFAULT_FLUSH_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            incompleteSends = this.pendingFutures.stream().filter(x -> !x.isDone()).count();
            String msg = String.format("Flush failed with error. Total pending sends %d", incompleteSends);
            LOG.error(msg, (Throwable)e);
            throw new SamzaException(msg, (Throwable)e);
        }
        this.pendingFutures.clear();
        this.checkForSendCallbackErrors("Sending one or more of the messages failed during flush.");
    }

    public abstract CompletableFuture<Void> sendAsync(String var1, OutgoingMessageEnvelope var2);

    protected void checkForSendCallbackErrors(String msg) {
        Throwable sendThrowable = this.sendExceptionOnCallback.get();
        if (sendThrowable != null) {
            LOG.error(msg, sendThrowable);
            throw new SamzaException(msg, sendThrowable);
        }
    }
}

