/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.eventhub.metrics;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.samza.metrics.Gauge;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsVisitor;

public class SamzaHistogram {
    private static final List<Double> DEFAULT_HISTOGRAM_PERCENTILES = Arrays.asList(50.0, 99.0);
    private final Histogram histogram = new Histogram((Reservoir)new ExponentiallyDecayingReservoir());
    private final List<Double> percentiles;
    private final Map<Double, Gauge<Double>> gauges;

    public SamzaHistogram(MetricsRegistry registry, String group, String name) {
        this(registry, group, name, DEFAULT_HISTOGRAM_PERCENTILES);
    }

    public SamzaHistogram(MetricsRegistry registry, String group, String name, List<Double> percentiles) {
        this.percentiles = percentiles;
        this.gauges = this.percentiles.stream().filter(x -> x > 0.0 && x <= 100.0).collect(Collectors.toMap(Function.identity(), x -> registry.newGauge(group, (Gauge)new HistogramGauge((Double)x, name + "_" + String.valueOf(x), 0.0))));
    }

    public void update(long value) {
        this.histogram.update(value);
    }

    public void updateGaugeValues(double percentile) {
        Snapshot values = this.histogram.getSnapshot();
        this.gauges.get(percentile).set((Object)values.getValue(percentile / 100.0));
    }

    private class HistogramGauge
    extends Gauge<Double> {
        private final Double percentile;

        public HistogramGauge(Double percentile, String name, double value) {
            super(name, (Object)value);
            this.percentile = percentile;
        }

        public void visit(MetricsVisitor visitor) {
            SamzaHistogram.this.updateGaugeValues(this.percentile);
            visitor.gauge((Gauge)this);
        }
    }
}

