/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.eventhub.descriptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.samza.operators.KV;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.SystemDescriptor;
import org.apache.samza.system.eventhub.EventHubSystemFactory;
import org.apache.samza.system.eventhub.descriptors.EventHubsInputDescriptor;
import org.apache.samza.system.eventhub.descriptors.EventHubsOutputDescriptor;
import org.apache.samza.system.eventhub.producer.EventHubSystemProducer;

public class EventHubsSystemDescriptor
extends SystemDescriptor<EventHubsSystemDescriptor> {
    private static final String FACTORY_CLASS_NAME = EventHubSystemFactory.class.getName();
    private List<String> streamIds = new ArrayList<String>();
    private Optional<Integer> fetchRuntimeInfoTimeout = Optional.empty();
    private Optional<Integer> numClientThreads = Optional.empty();
    private Optional<Integer> consumerReceiveQueueSize = Optional.empty();
    private Optional<Integer> consumerMaxEventCountPerPoll = Optional.empty();
    private Optional<Integer> consumerPrefetchCount = Optional.empty();
    private Optional<Boolean> producerEventhubsSendKey = Optional.empty();
    private Optional<EventHubSystemProducer.PartitioningMethod> producerEventhubsPartitioningMethod = Optional.empty();

    public EventHubsSystemDescriptor(String systemName) {
        super(systemName, FACTORY_CLASS_NAME, null, null);
    }

    public <ValueType> EventHubsInputDescriptor<KV<String, ValueType>> getInputDescriptor(String streamId, String namespace, String entityPath, Serde<ValueType> valueSerde) {
        this.streamIds.add(streamId);
        return new EventHubsInputDescriptor<KV<String, ValueType>>(streamId, namespace, entityPath, valueSerde, this);
    }

    public <ValueType> EventHubsOutputDescriptor<KV<String, ValueType>> getOutputDescriptor(String streamId, String namespace, String entityPath, Serde<ValueType> valueSerde) {
        this.streamIds.add(streamId);
        return new EventHubsOutputDescriptor<KV<String, ValueType>>(streamId, namespace, entityPath, valueSerde, this);
    }

    public EventHubsSystemDescriptor withRuntimeInfoTimeout(int timeoutMS) {
        this.fetchRuntimeInfoTimeout = Optional.of(timeoutMS);
        return this;
    }

    public EventHubsSystemDescriptor withNumClientThreads(int numClientThreads) {
        this.numClientThreads = Optional.of(numClientThreads);
        return this;
    }

    public EventHubsSystemDescriptor withReceiveQueueSize(int receiveQueueSize) {
        this.consumerReceiveQueueSize = Optional.of(receiveQueueSize);
        return this;
    }

    public EventHubsSystemDescriptor withMaxEventCountPerPoll(int count) {
        this.consumerMaxEventCountPerPoll = Optional.of(count);
        return this;
    }

    public EventHubsSystemDescriptor withPrefetchCount(int count) {
        this.consumerPrefetchCount = Optional.of(count);
        return this;
    }

    public EventHubsSystemDescriptor withPartitioningMethod(EventHubSystemProducer.PartitioningMethod partitioningMethod) {
        this.producerEventhubsPartitioningMethod = Optional.ofNullable(partitioningMethod);
        return this;
    }

    public EventHubsSystemDescriptor withSendKeys(boolean sendKeys) {
        this.producerEventhubsSendKey = Optional.of(sendKeys);
        return this;
    }

    public Map<String, String> toConfig() {
        HashMap<String, String> ehConfigs = new HashMap<String, String>(super.toConfig());
        String systemName = this.getSystemName();
        if (!this.streamIds.isEmpty()) {
            ehConfigs.put(String.format("systems.%s.stream.list", systemName), String.join((CharSequence)",", this.streamIds));
        }
        this.fetchRuntimeInfoTimeout.ifPresent(timeout -> ehConfigs.put(String.format("systems.%s.eventhubs.runtime.info.timeout", systemName), Integer.toString(timeout)));
        this.numClientThreads.ifPresent(numClientThreads -> ehConfigs.put(String.format("streams.%s.eventhubs.numClientThreads", systemName), Integer.toString(numClientThreads)));
        this.consumerReceiveQueueSize.ifPresent(receiveQueueSize -> ehConfigs.put(String.format("systems.%s.eventhubs.receive.queue.size", systemName), Integer.toString(receiveQueueSize)));
        this.consumerMaxEventCountPerPoll.ifPresent(count -> ehConfigs.put(String.format("systems.%s.eventhubs.maxEventCountPerPoll", systemName), Integer.toString(count)));
        this.consumerPrefetchCount.ifPresent(count -> ehConfigs.put(String.format("systems.%s.eventhubs.prefetchCount", systemName), Integer.toString(count)));
        this.producerEventhubsSendKey.ifPresent(sendKeys -> ehConfigs.put(String.format("systems.%s.eventhubs.send.key", systemName), Boolean.toString(sendKeys)));
        this.producerEventhubsPartitioningMethod.ifPresent(partitioningMethod -> ehConfigs.put(String.format("systems.%s.eventhubs.partition.method", systemName), partitioningMethod.toString()));
        return ehConfigs;
    }
}

