/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.eventhub.descriptors;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.config.ConfigException;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.InputDescriptor;
import org.apache.samza.system.descriptors.SystemDescriptor;

public class EventHubsInputDescriptor<StreamMessageType>
extends InputDescriptor<StreamMessageType, EventHubsInputDescriptor<StreamMessageType>> {
    private String namespace;
    private String entityPath;
    private Optional<String> sasKeyName = Optional.empty();
    private Optional<String> sasToken = Optional.empty();
    private Optional<String> consumerGroup = Optional.empty();

    EventHubsInputDescriptor(String streamId, String namespace, String entityPath, Serde valueSerde, SystemDescriptor systemDescriptor) {
        super(streamId, (Serde)KVSerde.of((Serde)new NoOpSerde(), (Serde)valueSerde), systemDescriptor, null);
        this.namespace = StringUtils.stripToNull((String)namespace);
        this.entityPath = StringUtils.stripToNull((String)entityPath);
        if (this.namespace == null || this.entityPath == null) {
            throw new ConfigException(String.format("Missing namespace and entity path Event Hubs input descriptor in system: {%s}, stream: {%s}", this.getSystemName(), streamId));
        }
    }

    public EventHubsInputDescriptor<StreamMessageType> withSasKeyName(String sasKeyName) {
        this.sasKeyName = Optional.of(StringUtils.stripToNull((String)sasKeyName));
        return this;
    }

    public EventHubsInputDescriptor<StreamMessageType> withSasKey(String sasToken) {
        this.sasToken = Optional.of(StringUtils.stripToNull((String)sasToken));
        return this;
    }

    public EventHubsInputDescriptor<StreamMessageType> withConsumerGroup(String consumerGroup) {
        this.consumerGroup = Optional.of(StringUtils.stripToNull((String)consumerGroup));
        return this;
    }

    public Map<String, String> toConfig() {
        HashMap<String, String> ehConfigs = new HashMap<String, String>(super.toConfig());
        String streamId = this.getStreamId();
        ehConfigs.put(String.format("streams.%s.eventhubs.namespace", streamId), this.namespace);
        ehConfigs.put(String.format("streams.%s.eventhubs.entitypath", streamId), this.entityPath);
        this.sasKeyName.ifPresent(keyName -> ehConfigs.put(String.format("sensitive.streams.%s.eventhubs.sas.keyname", streamId), (String)keyName));
        this.sasToken.ifPresent(key -> ehConfigs.put(String.format("sensitive.streams.%s.eventhubs.sas.token", streamId), (String)key));
        this.consumerGroup.ifPresent(consumerGroupName -> ehConfigs.put(String.format("streams.%s.eventhubs.consumer.group", streamId), (String)consumerGroupName));
        return ehConfigs;
    }
}

