/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.eventhub.consumer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.EventPosition;
import com.microsoft.azure.eventhubs.PartitionReceiveHandler;
import com.microsoft.azure.eventhubs.PartitionReceiver;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.samza.SamzaException;
import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.SlidingTimeWindowReservoir;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.eventhub.EventHubClientManager;
import org.apache.samza.system.eventhub.EventHubClientManagerFactory;
import org.apache.samza.system.eventhub.EventHubConfig;
import org.apache.samza.system.eventhub.Interceptor;
import org.apache.samza.system.eventhub.admin.EventHubSystemAdmin;
import org.apache.samza.system.eventhub.consumer.EventHubIncomingMessageEnvelope;
import org.apache.samza.system.eventhub.metrics.SamzaHistogram;
import org.apache.samza.util.BlockingEnvelopeMap;
import org.apache.samza.util.Clock;
import org.apache.samza.util.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubSystemConsumer
extends BlockingEnvelopeMap {
    private static final Logger LOG = LoggerFactory.getLogger(EventHubSystemConsumer.class);
    private static final Duration DEFAULT_EVENTHUB_RECEIVER_TIMEOUT = Duration.ofMinutes(10L);
    private static final long DEFAULT_SHUTDOWN_TIMEOUT_MILLIS = Duration.ofSeconds(15L).toMillis();
    public static final String START_OF_STREAM = "-1";
    public static final String END_OF_STREAM = "-2";
    public static final String EVENT_READ_RATE = "eventReadRate";
    public static final String EVENT_BYTE_READ_RATE = "eventByteReadRate";
    public static final String CONSUMPTION_LAG_MS = "consumptionLagMs";
    public static final String READ_ERRORS = "readErrors";
    public static final String AGGREGATE = "aggregate";
    private static final Object AGGREGATE_METRICS_LOCK = new Object();
    private static Counter aggEventReadRate = null;
    private static Counter aggEventByteReadRate = null;
    private static SamzaHistogram aggConsumptionLagMs = null;
    private static Counter aggReadErrors = null;
    private final Map<String, Counter> eventReadRates;
    private final Map<String, Counter> eventByteReadRates;
    private final Map<String, SamzaHistogram> consumptionLagMs;
    private final Map<String, Counter> readErrors;
    @VisibleForTesting
    final Map<SystemStreamPartition, PartitionReceiveHandler> streamPartitionHandlers = new ConcurrentHashMap<SystemStreamPartition, PartitionReceiveHandler>();
    @VisibleForTesting
    final Map<SystemStreamPartition, EventHubClientManager> perPartitionEventHubManagers = new ConcurrentHashMap<SystemStreamPartition, EventHubClientManager>();
    private final Map<SystemStreamPartition, PartitionReceiver> streamPartitionReceivers = new ConcurrentHashMap<SystemStreamPartition, PartitionReceiver>();
    private final Map<String, EventHubClientManager> perStreamEventHubManagers = new ConcurrentHashMap<String, EventHubClientManager>();
    private final Map<SystemStreamPartition, String> streamPartitionOffsets = new ConcurrentHashMap<SystemStreamPartition, String>();
    private final Map<String, Interceptor> interceptors;
    private final Integer prefetchCount;
    private volatile boolean isStarted = false;
    private final EventHubConfig config;
    private final String systemName;
    private final EventHubClientManagerFactory eventHubClientManagerFactory;
    private final AtomicReference<Throwable> eventHubNonTransientError = new AtomicReference<Object>(null);
    private final ExecutorService reconnectTaskRunner = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("EventHubs-Reconnect-Task").setDaemon(true).build());
    private long lastRetryTs = 0L;
    private final Clock clock;
    @VisibleForTesting
    final SlidingTimeWindowReservoir recentRetryAttempts;
    @VisibleForTesting
    volatile Future reconnectTaskStatus = null;

    public EventHubSystemConsumer(EventHubConfig config, String systemName, EventHubClientManagerFactory eventHubClientManagerFactory, Map<String, Interceptor> interceptors, MetricsRegistry registry) {
        this(config, systemName, eventHubClientManagerFactory, interceptors, registry, System::currentTimeMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventHubSystemConsumer(EventHubConfig config, String systemName, EventHubClientManagerFactory eventHubClientManagerFactory, Map<String, Interceptor> interceptors, MetricsRegistry registry, Clock clock) {
        super(registry, clock);
        this.config = config;
        this.clock = clock;
        this.systemName = systemName;
        this.interceptors = interceptors;
        this.eventHubClientManagerFactory = eventHubClientManagerFactory;
        List<String> streamIds = config.getStreams(systemName);
        this.prefetchCount = config.getPrefetchCount(systemName);
        this.recentRetryAttempts = new SlidingTimeWindowReservoir(config.getRetryWindowMs(systemName), clock);
        this.eventReadRates = streamIds.stream().collect(Collectors.toMap(Function.identity(), x -> registry.newCounter(x, EVENT_READ_RATE)));
        this.eventByteReadRates = streamIds.stream().collect(Collectors.toMap(Function.identity(), x -> registry.newCounter(x, EVENT_BYTE_READ_RATE)));
        this.consumptionLagMs = streamIds.stream().collect(Collectors.toMap(Function.identity(), x -> new SamzaHistogram(registry, (String)x, CONSUMPTION_LAG_MS)));
        this.readErrors = streamIds.stream().collect(Collectors.toMap(Function.identity(), x -> registry.newCounter(x, READ_ERRORS)));
        Object object = AGGREGATE_METRICS_LOCK;
        synchronized (object) {
            if (aggEventReadRate == null) {
                aggEventReadRate = registry.newCounter(AGGREGATE, EVENT_READ_RATE);
                aggEventByteReadRate = registry.newCounter(AGGREGATE, EVENT_BYTE_READ_RATE);
                aggConsumptionLagMs = new SamzaHistogram(registry, AGGREGATE, CONSUMPTION_LAG_MS);
                aggReadErrors = registry.newCounter(AGGREGATE, READ_ERRORS);
            }
        }
    }

    public void register(SystemStreamPartition systemStreamPartition, String offset) {
        super.register(systemStreamPartition, offset);
        LOG.info(String.format("Eventhub consumer trying to register ssp %s, offset %s", systemStreamPartition, offset));
        if (this.isStarted) {
            throw new SamzaException("Trying to add partition when the connection has already started.");
        }
        if (this.streamPartitionOffsets.containsKey(systemStreamPartition)) {
            if (END_OF_STREAM.equals(offset)) {
                return;
            }
            String prevOffset = this.streamPartitionOffsets.get(systemStreamPartition);
            if (!END_OF_STREAM.equals(prevOffset) && EventHubSystemAdmin.compareOffsets(offset, prevOffset) > -1) {
                return;
            }
        }
        this.streamPartitionOffsets.put(systemStreamPartition, offset);
    }

    private EventHubClientManager createOrGetEventHubClientManagerForSSP(String streamId, SystemStreamPartition ssp) {
        EventHubClientManager eventHubClientManager;
        if (this.config.getPerPartitionConnection(this.systemName).booleanValue()) {
            if (this.perPartitionEventHubManagers.containsKey(ssp)) {
                LOG.warn(String.format("Trying to create new EventHubClientManager for ssp=%s. But one already exists", ssp));
                eventHubClientManager = this.perPartitionEventHubManagers.get(ssp);
            } else {
                LOG.info("Creating EventHub client manager for SSP: " + ssp);
                eventHubClientManager = this.eventHubClientManagerFactory.getEventHubClientManager(this.systemName, streamId, this.config);
                eventHubClientManager.init();
                this.perPartitionEventHubManagers.put(ssp, eventHubClientManager);
            }
        } else {
            if (!this.perStreamEventHubManagers.containsKey(streamId)) {
                LOG.info("Creating EventHub client manager for stream: " + streamId);
                EventHubClientManager perStreamEventHubClientManager = this.eventHubClientManagerFactory.getEventHubClientManager(this.systemName, streamId, this.config);
                perStreamEventHubClientManager.init();
                this.perStreamEventHubManagers.put(streamId, perStreamEventHubClientManager);
            }
            eventHubClientManager = this.perStreamEventHubManagers.get(streamId);
            this.perPartitionEventHubManagers.put(ssp, eventHubClientManager);
        }
        LOG.info("EventHub client created for ssp: " + ssp);
        Validate.notNull((Object)eventHubClientManager, (String)String.format("Fail to create or get EventHubClientManager for ssp=%s", ssp), (Object[])new Object[0]);
        return eventHubClientManager;
    }

    private synchronized void initializeEventHubsManagers() {
        LOG.info("Starting EventHubSystemConsumer. Count of SSPs registered: " + this.streamPartitionOffsets.entrySet().size());
        this.eventHubNonTransientError.set(null);
        for (Map.Entry<SystemStreamPartition, String> entry : this.streamPartitionOffsets.entrySet()) {
            SystemStreamPartition ssp = entry.getKey();
            String streamId = this.config.getStreamId(ssp.getStream());
            Integer partitionId = ssp.getPartition().getPartitionId();
            String offset = entry.getValue();
            String consumerGroup = this.config.getStreamConsumerGroup(this.systemName, streamId);
            String namespace = this.config.getStreamNamespace(this.systemName, streamId);
            String entityPath = this.config.getStreamEntityPath(this.systemName, streamId);
            EventHubClientManager eventHubClientManager = this.createOrGetEventHubClientManagerForSSP(streamId, ssp);
            try {
                PartitionReceiver receiver = END_OF_STREAM.equals(offset) ? eventHubClientManager.getEventHubClient().createReceiverSync(consumerGroup, partitionId.toString(), EventPosition.fromEnqueuedTime((Instant)Instant.now())) : eventHubClientManager.getEventHubClient().createReceiverSync(consumerGroup, partitionId.toString(), EventPosition.fromOffset((String)offset, (boolean)false));
                receiver.setPrefetchCount(this.prefetchCount.intValue());
                PartitionReceiverHandlerImpl handler = new PartitionReceiverHandlerImpl(ssp, this.eventReadRates.get(streamId), this.eventByteReadRates.get(streamId), this.consumptionLagMs.get(streamId), this.readErrors.get(streamId), this.interceptors.getOrDefault(streamId, null), this.config.getMaxEventCountPerPoll(this.systemName));
                receiver.setReceiveTimeout(DEFAULT_EVENTHUB_RECEIVER_TIMEOUT);
                receiver.setReceiveHandler((PartitionReceiveHandler)handler);
                this.streamPartitionHandlers.put(ssp, handler);
                this.streamPartitionReceivers.put(ssp, receiver);
            }
            catch (Exception e) {
                throw new SamzaException(String.format("Failed to create receiver for EventHubs: namespace=%s, entity=%s, partitionId=%d", namespace, entityPath, partitionId), (Throwable)e);
            }
            LOG.info(String.format("Connection successfully started for namespace=%s, entity=%s ", namespace, entityPath));
        }
    }

    public void start() {
        if (this.isStarted) {
            LOG.warn("Trying to start EventHubSystemConsumer while it's already started. Ignore the request.");
            return;
        }
        this.isStarted = true;
        this.initializeEventHubsManagers();
        LOG.info("EventHubSystemConsumer started");
    }

    public Map<SystemStreamPartition, List<IncomingMessageEnvelope>> poll(Set<SystemStreamPartition> systemStreamPartitions, long timeout) throws InterruptedException {
        Throwable handlerError = this.eventHubNonTransientError.get();
        if (handlerError != null && this.clock.currentTimeMillis() - this.lastRetryTs > this.config.getMinRetryIntervalMs(this.systemName)) {
            long maxRetryCount;
            int currentRetryCount = this.recentRetryAttempts.size();
            if ((long)currentRetryCount < (maxRetryCount = this.config.getMaxRetryCount(this.systemName))) {
                LOG.warn("Received non transient error. Will retry.", handlerError);
                LOG.info("Current retry count within window: {}. max retry count allowed: {}. window size: {} ms", new Object[]{currentRetryCount, maxRetryCount, this.config.getRetryWindowMs(this.systemName)});
                long now = this.clock.currentTimeMillis();
                this.recentRetryAttempts.update(now);
                this.lastRetryTs = now;
                this.reconnectTaskStatus = this.reconnectTaskRunner.submit(this::renewEventHubsClient);
            } else {
                LOG.error("Retries exhausted. Reached max allowed retries: ({}) within window {} ms", (Object)currentRetryCount, (Object)this.config.getRetryWindowMs(this.systemName));
                String msg = "Received a non transient error from event hub partition receiver";
                throw new SamzaException(msg, handlerError);
            }
        }
        return super.poll(systemStreamPartitions, timeout);
    }

    private synchronized void renewEventHubsClient() {
        try {
            LOG.info("Start to renew eventhubs client");
            this.shutdownEventHubsManagers();
            this.initializeEventHubsManagers();
        }
        catch (Exception e) {
            LOG.error("Failed to renew eventhubs client", (Throwable)e);
            this.eventHubNonTransientError.set(e);
        }
    }

    private void renewPartitionReceiver(SystemStreamPartition ssp) {
        String streamId = this.config.getStreamId(ssp.getStream());
        EventHubClientManager eventHubClientManager = this.perPartitionEventHubManagers.get(ssp);
        String offset = this.streamPartitionOffsets.get(ssp);
        Integer partitionId = ssp.getPartition().getPartitionId();
        String consumerGroup = this.config.getStreamConsumerGroup(ssp.getSystem(), streamId);
        try {
            this.streamPartitionReceivers.get(ssp).close().get(DEFAULT_SHUTDOWN_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            PartitionReceiver receiver = eventHubClientManager.getEventHubClient().createReceiverSync(consumerGroup, partitionId.toString(), EventPosition.fromOffset((String)offset, (!offset.equals(START_OF_STREAM) ? 1 : 0) != 0));
            receiver.setPrefetchCount(this.prefetchCount.intValue());
            receiver.setReceiveTimeout(DEFAULT_EVENTHUB_RECEIVER_TIMEOUT);
            receiver.setReceiveHandler(this.streamPartitionHandlers.get(ssp));
            this.streamPartitionReceivers.put(ssp, receiver);
        }
        catch (Exception e) {
            this.eventHubNonTransientError.set((Throwable)new SamzaException(String.format("Failed to recreate receiver for EventHubs after ReceiverHandlerError (ssp=%s)", ssp), (Throwable)e));
        }
    }

    private synchronized void shutdownEventHubsManagers() {
        LOG.info("Start shutting down eventhubs receivers");
        ShutdownUtil.boundedShutdown(this.streamPartitionReceivers.values().stream().map(receiver -> new Runnable((PartitionReceiver)receiver){
            final /* synthetic */ PartitionReceiver val$receiver;
            {
                this.val$receiver = partitionReceiver;
            }

            @Override
            public void run() {
                try {
                    this.val$receiver.close().get(DEFAULT_SHUTDOWN_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    LOG.error("Failed to shutdown receiver.", (Throwable)e);
                }
            }
        }).collect(Collectors.toList()), (String)"EventHubSystemConsumer.Receiver#close", (long)DEFAULT_SHUTDOWN_TIMEOUT_MILLIS);
        LOG.info("Start shutting down eventhubs managers");
        ShutdownUtil.boundedShutdown(this.perPartitionEventHubManagers.values().stream().map(manager -> new Runnable((EventHubClientManager)manager){
            final /* synthetic */ EventHubClientManager val$manager;
            {
                this.val$manager = eventHubClientManager;
            }

            @Override
            public void run() {
                try {
                    this.val$manager.close(DEFAULT_SHUTDOWN_TIMEOUT_MILLIS);
                }
                catch (Exception e) {
                    LOG.error("Failed to shutdown eventhubs manager.", (Throwable)e);
                }
            }
        }).collect(Collectors.toList()), (String)"EventHubSystemConsumer.ClientManager#close", (long)DEFAULT_SHUTDOWN_TIMEOUT_MILLIS);
        this.perPartitionEventHubManagers.clear();
        this.perStreamEventHubManagers.clear();
    }

    public void stop() {
        LOG.info("Stopping event hub system consumer...");
        try {
            this.reconnectTaskRunner.shutdown();
            this.shutdownEventHubsManagers();
            this.isStarted = false;
        }
        catch (Exception e) {
            LOG.warn("Exception during stop.", (Throwable)e);
        }
        LOG.info("Event hub system consumer stopped.");
    }

    protected BlockingQueue<IncomingMessageEnvelope> newBlockingQueue() {
        return new LinkedBlockingQueue<IncomingMessageEnvelope>(this.config.getConsumerBufferCapacity(this.systemName));
    }

    protected class PartitionReceiverHandlerImpl
    implements PartitionReceiveHandler {
        private final Counter eventReadRate;
        private final Counter eventByteReadRate;
        private final SamzaHistogram readLatency;
        private final Counter errorRate;
        private final Interceptor interceptor;
        private final Integer maxEventCount;
        SystemStreamPartition ssp;

        PartitionReceiverHandlerImpl(SystemStreamPartition ssp, Counter eventReadRate, Counter eventByteReadRate, SamzaHistogram readLatency, Counter readErrors, Interceptor interceptor, int maxEventCount) {
            this.ssp = ssp;
            this.eventReadRate = eventReadRate;
            this.eventByteReadRate = eventByteReadRate;
            this.readLatency = readLatency;
            this.errorRate = readErrors;
            this.interceptor = interceptor;
            this.maxEventCount = maxEventCount;
        }

        public int getMaxEventCount() {
            return this.maxEventCount;
        }

        public void onReceive(Iterable<EventData> events) {
            if (events != null) {
                events.forEach(event -> {
                    byte[] eventDataBody = event.getBytes();
                    if (this.interceptor != null) {
                        eventDataBody = this.interceptor.intercept(eventDataBody);
                    }
                    String offset = event.getSystemProperties().getOffset();
                    String partitionKey = event.getSystemProperties().getPartitionKey();
                    if (partitionKey == null) {
                        partitionKey = event.getProperties().get("key");
                    }
                    try {
                        this.updateMetrics((EventData)event);
                        EventHubSystemConsumer.this.put(this.ssp, new EventHubIncomingMessageEnvelope(this.ssp, offset, partitionKey, eventDataBody, (EventData)event));
                    }
                    catch (InterruptedException e) {
                        String msg = String.format("Interrupted while adding the event from ssp %s to dispatch queue.", this.ssp);
                        LOG.error(msg, (Throwable)e);
                        throw new SamzaException(msg, (Throwable)e);
                    }
                    EventHubSystemConsumer.this.streamPartitionOffsets.put(this.ssp, offset);
                });
            }
        }

        private void updateMetrics(EventData event) {
            int eventDataLength = event.getBytes() == null ? 0 : event.getBytes().length;
            this.eventReadRate.inc();
            aggEventReadRate.inc();
            this.eventByteReadRate.inc((long)eventDataLength);
            aggEventByteReadRate.inc((long)eventDataLength);
            long latencyMs = Duration.between(event.getSystemProperties().getEnqueuedTime(), Instant.now()).toMillis();
            this.readLatency.update(latencyMs);
            aggConsumptionLagMs.update(latencyMs);
        }

        public void onError(Throwable throwable) {
            EventHubException busException;
            this.errorRate.inc();
            aggReadErrors.inc();
            if (throwable instanceof EventHubException && (busException = (EventHubException)throwable).getIsTransient()) {
                LOG.warn(String.format("Received transient exception from EH client. Renew partition receiver for ssp: %s", this.ssp), throwable);
                try {
                    Thread.sleep(Duration.ofSeconds(2L).toMillis());
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted during sleep before renew", (Throwable)e);
                }
                EventHubSystemConsumer.this.renewPartitionReceiver(this.ssp);
                return;
            }
            LOG.error(String.format("Received non transient exception from EH client for ssp: %s", this.ssp), throwable);
            EventHubSystemConsumer.this.eventHubNonTransientError.set(throwable);
        }
    }
}

