/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.eventhub.admin;

import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.EventHubRuntimeInformation;
import com.microsoft.azure.eventhubs.PartitionRuntimeInformation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.eventhub.EventHubClientManager;
import org.apache.samza.system.eventhub.EventHubClientManagerFactory;
import org.apache.samza.system.eventhub.EventHubConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubSystemAdmin
implements SystemAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(EventHubSystemAdmin.class);
    private static final long DEFAULT_SHUTDOWN_TIMEOUT_MILLIS = Duration.ofMinutes(1L).toMillis();
    private final EventHubClientManagerFactory eventHubClientManagerFactory;
    private final String systemName;
    private final EventHubConfig eventHubConfig;
    private final Map<String, EventHubClientManager> eventHubClients = new HashMap<String, EventHubClientManager>();
    private final Map<String, String[]> streamPartitions = new HashMap<String, String[]>();

    public EventHubSystemAdmin(String systemName, EventHubConfig eventHubConfig, EventHubClientManagerFactory eventHubClientManagerFactory) {
        this.systemName = systemName;
        this.eventHubConfig = eventHubConfig;
        this.eventHubClientManagerFactory = eventHubClientManagerFactory;
    }

    public Map<SystemStreamPartition, String> getOffsetsAfter(Map<SystemStreamPartition, String> offsets) {
        return offsets;
    }

    private String printEventHubRuntimeInfo(EventHubRuntimeInformation ehInfo) {
        if (ehInfo == null) {
            return "[EventHubRuntimeInformation: null]";
        }
        return String.format("[EventHubRuntimeInformation: createAt=%s, partitionCount=%d, path=%s]", ehInfo.getCreatedAt(), ehInfo.getPartitionCount(), ehInfo.getPath());
    }

    private String printPartitionRuntimeInfo(PartitionRuntimeInformation runtimeInformation) {
        if (runtimeInformation == null) {
            return "[PartitionRuntimeInformation: null]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[PartitionRuntimeInformation:");
        stringBuilder.append(" eventHubPath=").append(runtimeInformation.getEventHubPath());
        stringBuilder.append(" partitionId=").append(runtimeInformation.getPartitionId());
        stringBuilder.append(" lastEnqueuedTimeUtc=").append(runtimeInformation.getLastEnqueuedTimeUtc().toString());
        stringBuilder.append(" lastEnqueuedOffset=").append(runtimeInformation.getLastEnqueuedOffset());
        stringBuilder.append(" numMessages=").append(runtimeInformation.getLastEnqueuedSequenceNumber() - runtimeInformation.getBeginSequenceNumber());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public Map<String, SystemStreamMetadata> getSystemStreamMetadata(Set<String> streamNames) {
        HashMap<String, SystemStreamMetadata> requestedMetadata = new HashMap<String, SystemStreamMetadata>();
        try {
            for (String streamName2 : streamNames) {
                if (!this.streamPartitions.containsKey(streamName2)) {
                    LOG.debug(String.format("Partition ids for Stream=%s not found", streamName2));
                    EventHubClientManager eventHubClientManager = this.getOrCreateStreamEventHubClient(streamName2);
                    EventHubClient ehClient = eventHubClientManager.getEventHubClient();
                    CompletableFuture runtimeInfo = ehClient.getRuntimeInformation();
                    long timeoutMs = this.eventHubConfig.getRuntimeInfoWaitTimeMS(this.systemName);
                    EventHubRuntimeInformation ehInfo = (EventHubRuntimeInformation)runtimeInfo.get(timeoutMs, TimeUnit.MILLISECONDS);
                    LOG.info(String.format("Adding partition ids=%s for stream=%s. EHRuntimetInfo=%s", Arrays.toString(ehInfo.getPartitionIds()), streamName2, this.printEventHubRuntimeInfo(ehInfo)));
                    this.streamPartitions.put(streamName2, ehInfo.getPartitionIds());
                }
                String[] partitionIds = this.streamPartitions.get(streamName2);
                Map<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata> sspMetadataMap = this.getPartitionMetadata(streamName2, partitionIds);
                SystemStreamMetadata systemStreamMetadata = new SystemStreamMetadata(streamName2, sspMetadataMap);
                requestedMetadata.put(streamName2, systemStreamMetadata);
            }
        }
        catch (Exception e) {
            String msg = String.format("Error while fetching EventHubRuntimeInfo for System:%s", this.systemName);
            LOG.error(msg, (Throwable)e);
            throw new SamzaException(msg, (Throwable)e);
        }
        finally {
            this.eventHubClients.forEach((streamName, client) -> client.close(DEFAULT_SHUTDOWN_TIMEOUT_MILLIS));
            this.eventHubClients.clear();
        }
        return requestedMetadata;
    }

    private EventHubClientManager getOrCreateStreamEventHubClient(String streamName) {
        if (!this.eventHubClients.containsKey(streamName)) {
            LOG.info(String.format("Creating EventHubClient for Stream=%s", streamName));
            EventHubClientManager eventHubClientManager = this.eventHubClientManagerFactory.getEventHubClientManager(this.systemName, streamName, this.eventHubConfig);
            eventHubClientManager.init();
            this.eventHubClients.put(streamName, eventHubClientManager);
        }
        return this.eventHubClients.get(streamName);
    }

    private Map<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata> getPartitionMetadata(String streamName, String[] partitionIds) {
        EventHubClientManager eventHubClientManager = this.getOrCreateStreamEventHubClient(streamName);
        HashMap<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata> sspMetadataMap = new HashMap<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata>();
        ArrayList<CompletableFuture> futureList = new ArrayList<CompletableFuture>();
        for (String partition : partitionIds) {
            CompletableFuture partitionRuntimeInfo = eventHubClientManager.getEventHubClient().getPartitionRuntimeInformation(partition);
            futureList.add(partitionRuntimeInfo);
            partitionRuntimeInfo.thenAccept(ehPartitionInfo -> {
                LOG.info(this.printPartitionRuntimeInfo((PartitionRuntimeInformation)ehPartitionInfo));
                String startingOffset = "-1";
                String newestOffset = ehPartitionInfo.getLastEnqueuedOffset();
                String upcomingOffset = "-2";
                SystemStreamMetadata.SystemStreamPartitionMetadata sspMetadata = new SystemStreamMetadata.SystemStreamPartitionMetadata(startingOffset, newestOffset, upcomingOffset);
                sspMetadataMap.put(new Partition(Integer.parseInt(partition)), sspMetadata);
            });
        }
        CompletableFuture<Void> futureGroup = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[futureList.size()]));
        long timeoutMs = this.eventHubConfig.getRuntimeInfoWaitTimeMS(this.systemName);
        try {
            futureGroup.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            String msg = String.format("Error while fetching EventHubPartitionRuntimeInfo for System:%s, Stream:%s", this.systemName, streamName);
            LOG.error(msg, (Throwable)e);
            throw new SamzaException(msg, (Throwable)e);
        }
        return sspMetadataMap;
    }

    public static Integer compareOffsets(String offset1, String offset2) {
        if (offset1 == null || offset2 == null) {
            return null;
        }
        if ("-2".equals(offset1) || "-2".equals(offset2)) {
            return null;
        }
        try {
            return Long.compare(Long.parseLong(offset1), Long.parseLong(offset2));
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }

    public Integer offsetComparator(String offset1, String offset2) {
        return EventHubSystemAdmin.compareOffsets(offset1, offset2);
    }
}

