/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.eventhub;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.microsoft.azure.eventhubs.ConnectionStringBuilder;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.RetryPolicy;
import com.microsoft.azure.eventhubs.impl.RetryExponential;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.samza.SamzaException;
import org.apache.samza.system.eventhub.EventHubClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaEventHubClientManager
implements EventHubClientManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)SamzaEventHubClientManager.class.getName());
    private static final String EVENTHUB_REMOTE_HOST_FORMAT = "%s.servicebus.windows.net";
    private static final Duration MIN_RETRY_BACKOFF = Duration.ofMillis(100L);
    private static final Duration MAX_RETRY_BACKOFF = Duration.ofMillis(11000L);
    private static final int MAX_RETRY_COUNT = 100;
    private static final String SAMZA_EVENTHUB_RETRY = "SAMZA_CONNECTOR_RETRY";
    private final int numClientThreads;
    private EventHubClient eventHubClient;
    private final String eventHubNamespace;
    private final String entityPath;
    private final String sasKeyName;
    private final String sasKey;
    private final RetryPolicy retryPolicy;
    private ExecutorService eventHubClientExecutor;

    public SamzaEventHubClientManager(String eventHubNamespace, String entityPath, String sasKeyName, String sasKey, Integer numClientThreads) {
        this(eventHubNamespace, entityPath, sasKeyName, sasKey, (RetryPolicy)new RetryExponential(MIN_RETRY_BACKOFF, MAX_RETRY_BACKOFF, 100, SAMZA_EVENTHUB_RETRY), numClientThreads);
    }

    public SamzaEventHubClientManager(String eventHubNamespace, String entityPath, String sasKeyName, String sasKey, RetryPolicy retryPolicy, int numClientThreads) {
        this.eventHubNamespace = eventHubNamespace;
        this.entityPath = entityPath;
        this.sasKeyName = sasKeyName;
        this.sasKey = sasKey;
        this.retryPolicy = retryPolicy;
        this.numClientThreads = numClientThreads;
    }

    @Override
    public void init() {
        String remoteHost = String.format(EVENTHUB_REMOTE_HOST_FORMAT, this.eventHubNamespace);
        LOG.info("Initializing SamzaEventHubClientManager for namespace: " + this.eventHubNamespace);
        try {
            ConnectionStringBuilder connectionStringBuilder = new ConnectionStringBuilder().setNamespaceName(this.eventHubNamespace).setEventHubName(this.entityPath).setSasKeyName(this.sasKeyName).setSasKey(this.sasKey);
            ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder().setNameFormat("Samza EventHubClient Thread-%d").setDaemon(true);
            this.eventHubClientExecutor = Executors.newFixedThreadPool(this.numClientThreads, threadFactoryBuilder.build());
            this.eventHubClient = EventHubClient.createSync((String)connectionStringBuilder.toString(), (RetryPolicy)this.retryPolicy, (Executor)this.eventHubClientExecutor);
        }
        catch (EventHubException | IOException e) {
            String msg = String.format("Creation of EventHub client failed for eventHub EntityPath: %s on remote host %s:%d", this.entityPath, remoteHost, 5671);
            LOG.error(msg, e);
            throw new SamzaException(msg, e);
        }
        LOG.info("SamzaEventHubClientManager initialized for namespace: " + this.eventHubNamespace);
    }

    @Override
    public EventHubClient getEventHubClient() {
        return this.eventHubClient;
    }

    @Override
    public void close(long timeoutMS) {
        try {
            if (timeoutMS == -1L) {
                this.eventHubClient.closeSync();
                this.eventHubClientExecutor.shutdown();
            } else {
                CompletableFuture future = this.eventHubClient.close();
                future.get(timeoutMS, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            LOG.error("Closing the EventHub client failed", (Throwable)e);
        }
    }
}

