/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.eventhub;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.SystemProducer;
import org.apache.samza.system.eventhub.EventHubClientManagerFactory;
import org.apache.samza.system.eventhub.EventHubConfig;
import org.apache.samza.system.eventhub.Interceptor;
import org.apache.samza.system.eventhub.admin.EventHubSystemAdmin;
import org.apache.samza.system.eventhub.admin.PassThroughInterceptor;
import org.apache.samza.system.eventhub.consumer.EventHubSystemConsumer;
import org.apache.samza.system.eventhub.producer.EventHubSystemProducer;

public class EventHubSystemFactory
implements SystemFactory {
    private Map<String, Interceptor> getInterceptorsMap(EventHubConfig config, String systemName) {
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        List<String> streamList = config.getStreams(systemName);
        streamList.forEach(streamName -> {
            Interceptor cfr_ignored_0 = interceptors.put((String)streamName, new PassThroughInterceptor());
        });
        return interceptors;
    }

    public SystemConsumer getConsumer(String systemName, Config config, MetricsRegistry registry) {
        EventHubConfig eventHubConfig = new EventHubConfig(config);
        return new EventHubSystemConsumer(eventHubConfig, systemName, new EventHubClientManagerFactory(), this.getInterceptorsMap(eventHubConfig, systemName), registry);
    }

    public SystemProducer getProducer(String systemName, Config config, MetricsRegistry registry) {
        EventHubConfig eventHubConfig = new EventHubConfig(config);
        return new EventHubSystemProducer(eventHubConfig, systemName, new EventHubClientManagerFactory(), this.getInterceptorsMap(eventHubConfig, systemName), registry);
    }

    public SystemAdmin getAdmin(String systemName, Config config) {
        return new EventHubSystemAdmin(systemName, new EventHubConfig(config), new EventHubClientManagerFactory());
    }
}

