/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.eventhub;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.system.eventhub.producer.EventHubSystemProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

public class EventHubConfig
extends MapConfig {
    public static final String CONFIG_STREAM_LIST = "systems.%s.stream.list";
    public static final String CONFIG_STREAM_NAMESPACE = "streams.%s.eventhubs.namespace";
    public static final String CONFIG_STREAM_ENTITYPATH = "streams.%s.eventhubs.entitypath";
    public static final String CONFIG_STREAM_SAS_KEY_NAME = "sensitive.streams.%s.eventhubs.sas.keyname";
    public static final String CONFIG_STREAM_SAS_TOKEN = "sensitive.streams.%s.eventhubs.sas.token";
    public static final String CONFIG_SKIP_MESSAGES_LARGER_THAN = "systems.%s.eventhubs.skipMessagesLargerThanBytes";
    public static final String CONFIG_STREAM_CONSUMER_GROUP = "streams.%s.eventhubs.consumer.group";
    public static final String DEFAULT_CONFIG_STREAM_CONSUMER_GROUP = "$Default";
    public static final String CONFIG_SYSTEM_NUM_CLIENT_THREADS = "streams.%s.eventhubs.numClientThreads";
    public static final int DEFAULT_CONFIG_SYSTEM_NUM_CLIENT_THREADS = 10;
    public static final String CONFIG_PREFETCH_COUNT = "systems.%s.eventhubs.prefetchCount";
    public static final int DEFAULT_CONFIG_PREFETCH_COUNT = 999;
    public static final String CONFIG_MAX_EVENT_COUNT_PER_POLL = "systems.%s.eventhubs.maxEventCountPerPoll";
    public static final int DEFAULT_CONFIG_MAX_EVENT_COUNT_PER_POLL = 50;
    public static final String CONFIG_PRODUCER_PARTITION_METHOD = "systems.%s.eventhubs.partition.method";
    public static final String DEFAULT_CONFIG_PRODUCER_PARTITION_METHOD = EventHubSystemProducer.PartitioningMethod.EVENT_HUB_HASHING.name();
    public static final String CONFIG_SEND_KEY_IN_EVENT_PROPERTIES = "systems.%s.eventhubs.send.key";
    public static final Boolean DEFAULT_CONFIG_SEND_KEY_IN_EVENT_PROPERTIES = true;
    public static final String CONFIG_FETCH_RUNTIME_INFO_TIMEOUT_MILLIS = "systems.%s.eventhubs.runtime.info.timeout";
    public static final long DEFAULT_CONFIG_FETCH_RUNTIME_INFO_TIMEOUT_MILLIS = Duration.ofMinutes(1L).toMillis();
    public static final String CONFIG_CONSUMER_BUFFER_CAPACITY = "systems.%s.eventhubs.receive.queue.size";
    public static final int DEFAULT_CONFIG_CONSUMER_BUFFER_CAPACITY = 100;
    private static final int MESSAGE_HEADER_OVERHEAD = 24576;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 1024000;
    public static final String CONFIG_PER_PARTITION_CONNECTION = "systems.%s.eventhubs.perPartition.connection";
    public static final Boolean DEFAULT_CONFIG_PER_PARTITION_CONNECTION = true;
    public static final String CONFIG_MAX_RETRY_COUNT = "systems.%s.eventhubs.max.retry.count";
    public static final long DEFAULT_CONFIG_MAX_RETRIES_COUNT = 3L;
    public static final String CONFIG_RETRY_WINDOW_MS = "systems.%s.eventhubs.retry.window.ms";
    public static final long DEFAULT_CONFIG_RETRY_WINDOW_MS = Duration.ofHours(3L).toMillis();
    public static final String CONFIG_MIN_RETRY_INTERVAL_MS = "systems.%s.eventhubs.min.retry.interval.ms";
    public static final long DEFAULT_CONFIG_RETRY_INTERVAL_MS = Duration.ofMinutes(3L).toMillis();
    private final Map<String, String> physcialToId = new HashMap<String, String>();
    private static final Logger LOG = LoggerFactory.getLogger(EventHubConfig.class);

    public EventHubConfig(Config config) {
        super((Map)config);
        StreamConfig streamConfig = new StreamConfig(config);
        LOG.info("Building mappings from physicalName to streamId");
        JavaConversions.asJavaCollection((Iterable)streamConfig.getStreamIds()).forEach(streamId -> {
            String physicalName = streamConfig.getPhysicalName(streamId);
            LOG.info("Obtained physicalName: {} for streamId: {} ", (Object)physicalName, streamId);
            this.physcialToId.put(physicalName, (String)streamId);
        });
    }

    private String getFromStreamIdOrName(String configName, String streamName, String defaultString) {
        String result = this.getFromStreamIdOrName(configName, streamName);
        if (result == null) {
            return defaultString;
        }
        return result;
    }

    private String getFromStreamIdOrName(String configName, String streamName) {
        String streamId = this.getStreamId(streamName);
        return this.get(String.format(configName, streamId), streamId.equals(streamName) ? null : this.get(String.format(configName, streamName)));
    }

    private String validateRequiredConfig(String value, String fieldName, String systemName, String streamName) {
        if (value == null) {
            throw new SamzaException(String.format("Missing %s configuration for system: %s, stream: %s", fieldName, systemName, streamName));
        }
        return value;
    }

    public String getStreamId(String streamName) {
        return this.physcialToId.getOrDefault(streamName, streamName);
    }

    public List<String> getStreams(String systemName) {
        return this.getList(String.format(CONFIG_STREAM_LIST, systemName));
    }

    public String getStreamNamespace(String systemName, String streamName) {
        LOG.info("Obtaining name-space for system: {} physical name: {}", (Object)systemName, (Object)streamName);
        return this.validateRequiredConfig(this.getFromStreamIdOrName(CONFIG_STREAM_NAMESPACE, streamName), "Namespace", systemName, streamName);
    }

    public String getStreamEntityPath(String systemName, String streamName) {
        LOG.info("Obtaining entity-path for system: {} physical name: {}", (Object)systemName, (Object)streamName);
        return this.validateRequiredConfig(this.getFromStreamIdOrName(CONFIG_STREAM_ENTITYPATH, streamName), "EntityPath", systemName, streamName);
    }

    public Integer getNumClientThreads(String systemName) {
        return this.getInt(String.format(CONFIG_SYSTEM_NUM_CLIENT_THREADS, systemName), 10);
    }

    public Integer getMaxEventCountPerPoll(String systemName) {
        return this.getInt(String.format(CONFIG_MAX_EVENT_COUNT_PER_POLL, systemName), 50);
    }

    public Integer getPrefetchCount(String systemName) {
        return this.getInt(String.format(CONFIG_PREFETCH_COUNT, systemName), 999);
    }

    public Integer getSkipMessagesLargerThan(String systemName) {
        return this.getInt(String.format(CONFIG_SKIP_MESSAGES_LARGER_THAN, systemName), 1024000);
    }

    public String getStreamSasKeyName(String systemName, String streamName) {
        return this.validateRequiredConfig(this.getFromStreamIdOrName(CONFIG_STREAM_SAS_KEY_NAME, streamName), "SASKeyName", systemName, streamName);
    }

    public String getStreamSasToken(String systemName, String streamName) {
        return this.validateRequiredConfig(this.getFromStreamIdOrName(CONFIG_STREAM_SAS_TOKEN, streamName), "SASToken", systemName, streamName);
    }

    public String getStreamConsumerGroup(String systemName, String streamName) {
        return this.getFromStreamIdOrName(CONFIG_STREAM_CONSUMER_GROUP, streamName, DEFAULT_CONFIG_STREAM_CONSUMER_GROUP);
    }

    public EventHubSystemProducer.PartitioningMethod getPartitioningMethod(String systemName) {
        String partitioningMethod = this.get(String.format(CONFIG_PRODUCER_PARTITION_METHOD, systemName), DEFAULT_CONFIG_PRODUCER_PARTITION_METHOD);
        return EventHubSystemProducer.PartitioningMethod.valueOf(partitioningMethod);
    }

    public Boolean getSendKeyInEventProperties(String systemName) {
        String isSendKeyIncluded = this.get(String.format(CONFIG_SEND_KEY_IN_EVENT_PROPERTIES, systemName));
        if (isSendKeyIncluded == null) {
            return DEFAULT_CONFIG_SEND_KEY_IN_EVENT_PROPERTIES;
        }
        return Boolean.valueOf(isSendKeyIncluded);
    }

    public long getRuntimeInfoWaitTimeMS(String systemName) {
        return this.getLong(String.format(CONFIG_FETCH_RUNTIME_INFO_TIMEOUT_MILLIS, systemName), DEFAULT_CONFIG_FETCH_RUNTIME_INFO_TIMEOUT_MILLIS);
    }

    public int getConsumerBufferCapacity(String systemName) {
        String bufferCapacity = this.get(String.format(CONFIG_CONSUMER_BUFFER_CAPACITY, systemName));
        if (bufferCapacity == null) {
            return 100;
        }
        return Integer.parseInt(bufferCapacity);
    }

    public Boolean getPerPartitionConnection(String systemName) {
        String isPerPartitionConnection = this.get(String.format(CONFIG_PER_PARTITION_CONNECTION, systemName));
        if (isPerPartitionConnection == null) {
            return DEFAULT_CONFIG_PER_PARTITION_CONNECTION;
        }
        return Boolean.valueOf(isPerPartitionConnection);
    }

    public long getMaxRetryCount(String systemaName) {
        return this.getLong(String.format(CONFIG_MAX_RETRY_COUNT, systemaName), 3L);
    }

    public long getRetryWindowMs(String systemName) {
        return this.getLong(String.format(CONFIG_RETRY_WINDOW_MS, systemName), DEFAULT_CONFIG_RETRY_WINDOW_MS);
    }

    public long getMinRetryIntervalMs(String systemName) {
        return this.getLong(String.format(CONFIG_MIN_RETRY_INTERVAL_MS, systemName), DEFAULT_CONFIG_RETRY_INTERVAL_MS);
    }
}

