/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.samza.coordinator.scheduler.SchedulerStateChangeListener;
import org.apache.samza.coordinator.scheduler.TaskScheduler;
import org.apache.samza.util.LeaseBlobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewLeaseScheduler
implements TaskScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(RenewLeaseScheduler.class);
    private static final long RENEW_LEASE_DELAY_SEC = 45L;
    private static final ThreadFactory PROCESSOR_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("RenewLeaseScheduler-%d").build();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(PROCESSOR_THREAD_FACTORY);
    private final LeaseBlobManager leaseBlobManager;
    private final AtomicReference<String> leaseId;
    private final Consumer<String> errorHandler;

    public RenewLeaseScheduler(Consumer<String> errorHandler, LeaseBlobManager leaseBlobManager, AtomicReference<String> leaseId) {
        this.leaseBlobManager = leaseBlobManager;
        this.leaseId = leaseId;
        this.errorHandler = errorHandler;
    }

    @Override
    public ScheduledFuture scheduleTask() {
        return this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                LOG.info("Renewing lease");
                boolean status = this.leaseBlobManager.renewLease(this.leaseId.get());
                if (!status) {
                    this.errorHandler.accept("Unable to renew lease. Continuing as non-leader.");
                }
            }
            catch (Exception e) {
                this.errorHandler.accept("Exception in Renew Lease Scheduler. Continuing as non-leader.");
            }
        }, 45L, 45L, TimeUnit.SECONDS);
    }

    @Override
    public void setStateChangeListener(SchedulerStateChangeListener listener) {
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down RenewLeaseScheduler Scheduler.");
        this.scheduler.shutdownNow();
    }
}

