/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.samza.coordinator.scheduler.SchedulerStateChangeListener;
import org.apache.samza.coordinator.scheduler.TaskScheduler;
import org.apache.samza.util.BlobUtils;
import org.apache.samza.util.TableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivenessCheckScheduler
implements TaskScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(LivenessCheckScheduler.class);
    private static final long LIVENESS_CHECK_DELAY_SEC = 5L;
    private static final ThreadFactory PROCESSOR_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("LivenessCheckScheduler-%d").build();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(PROCESSOR_THREAD_FACTORY);
    private final TableUtils table;
    private final BlobUtils blob;
    private final AtomicReference<String> currentJMVersion;
    private final AtomicReference<List<String>> liveProcessorsList = new AtomicReference<Object>(null);
    private final Consumer<String> errorHandler;
    private SchedulerStateChangeListener listener = null;
    private final String processorId;

    public LivenessCheckScheduler(Consumer<String> errorHandler, TableUtils table, BlobUtils blob, AtomicReference<String> currentJMVersion, String pid) {
        this.table = table;
        this.blob = blob;
        this.currentJMVersion = currentJMVersion;
        this.errorHandler = errorHandler;
        this.processorId = pid;
    }

    @Override
    public ScheduledFuture scheduleTask() {
        return this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                if (!this.table.getEntity(this.currentJMVersion.get(), this.processorId).getIsLeader()) {
                    LOG.info("Not the leader anymore. Shutting down LivenessCheckScheduler.");
                    this.scheduler.shutdownNow();
                    return;
                }
                LOG.info("Checking for list of live processors");
                HashSet<String> currProcessors = new HashSet<String>(this.blob.getLiveProcessorList());
                Set<String> liveProcessors = this.table.getActiveProcessorsList(this.currentJMVersion);
                if (!liveProcessors.equals(currProcessors)) {
                    this.liveProcessorsList.getAndSet(new ArrayList<String>(liveProcessors));
                    this.listener.onStateChange();
                }
            }
            catch (Exception e) {
                this.errorHandler.accept("Exception in Liveness Check Scheduler. Stopping the processor...");
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public void setStateChangeListener(SchedulerStateChangeListener listener) {
        this.listener = listener;
    }

    public AtomicReference<List<String>> getLiveProcessors() {
        return this.liveProcessorsList;
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down LivenessCheckScheduler Scheduler.");
        this.scheduler.shutdownNow();
    }
}

