/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.samza.coordinator.data.ProcessorEntity;
import org.apache.samza.coordinator.scheduler.SchedulerStateChangeListener;
import org.apache.samza.coordinator.scheduler.TaskScheduler;
import org.apache.samza.util.BlobUtils;
import org.apache.samza.util.TableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderLivenessCheckScheduler
implements TaskScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderLivenessCheckScheduler.class);
    private static final long LIVENESS_CHECK_DELAY_SEC = 10L;
    private static final long LIVENESS_DEBOUNCE_TIME_SEC = 30L;
    private static final ThreadFactory PROCESSOR_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("LeaderLivenessCheckScheduler-%d").build();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(PROCESSOR_THREAD_FACTORY);
    private final TableUtils table;
    private final AtomicReference<String> currentJMVersion;
    private final BlobUtils blob;
    private final Consumer<String> errorHandler;
    private final String initialState;
    private SchedulerStateChangeListener listener = null;

    public LeaderLivenessCheckScheduler(Consumer<String> errorHandler, TableUtils table, BlobUtils blob, AtomicReference<String> currentJMVersion, String initialState) {
        this.table = table;
        this.blob = blob;
        this.currentJMVersion = currentJMVersion;
        this.initialState = initialState;
        this.errorHandler = errorHandler;
    }

    @Override
    public ScheduledFuture scheduleTask() {
        return this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                LOG.info("Checking for leader liveness");
                if (!this.checkIfLeaderAlive()) {
                    this.listener.onStateChange();
                }
            }
            catch (Exception e) {
                this.errorHandler.accept("Exception in Leader Liveness Check Scheduler. Stopping the processor...");
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void setStateChangeListener(SchedulerStateChangeListener listener) {
        this.listener = listener;
    }

    private boolean checkIfLeaderAlive() {
        String currJMV = this.currentJMVersion.get();
        String blobJMV = this.blob.getJobModelVersion();
        Iterable<ProcessorEntity> tableList = this.table.getEntitiesWithPartition(currJMV);
        ProcessorEntity leader = null;
        ProcessorEntity nextLeader = null;
        for (ProcessorEntity entity : tableList) {
            if (!entity.getIsLeader()) continue;
            leader = entity;
            break;
        }
        int currJMVInt = 0;
        if (!currJMV.equals(this.initialState)) {
            currJMVInt = Integer.valueOf(currJMV);
        }
        if (Integer.valueOf(blobJMV) > currJMVInt) {
            for (ProcessorEntity entity : this.table.getEntitiesWithPartition(blobJMV)) {
                if (!entity.getIsLeader()) continue;
                nextLeader = entity;
                break;
            }
        }
        return leader != null && System.currentTimeMillis() - leader.getTimestamp().getTime() < 30000L || nextLeader != null;
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down LeaderLivenessCheckScheduler Scheduler.");
        this.scheduler.shutdownNow();
    }
}

