/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.samza.coordinator.data.ProcessorEntity;
import org.apache.samza.coordinator.scheduler.SchedulerStateChangeListener;
import org.apache.samza.coordinator.scheduler.TaskScheduler;
import org.apache.samza.util.TableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderBarrierCompleteScheduler
implements TaskScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderBarrierCompleteScheduler.class);
    private static final long BARRIER_REACHED_DELAY_SEC = 5L;
    private static final long BARRIER_TIMEOUT_SEC = 30L;
    private static final ThreadFactory PROCESSOR_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("LeaderBarrierCompleteScheduler-%d").build();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(PROCESSOR_THREAD_FACTORY);
    private final TableUtils table;
    private final String nextJMVersion;
    private final Set<String> blobProcessorSet;
    private final long startTime;
    private final AtomicBoolean barrierTimeout;
    private final Consumer<String> errorHandler;
    private final String processorId;
    private final AtomicReference<String> currentJMVersion;
    private SchedulerStateChangeListener listener = null;

    public LeaderBarrierCompleteScheduler(Consumer<String> errorHandler, TableUtils table, String nextJMVersion, List<String> blobProcessorList, long startTime, AtomicBoolean barrierTimeout, AtomicReference<String> currentJMVersion, String pid) {
        this.table = table;
        this.nextJMVersion = nextJMVersion;
        this.blobProcessorSet = new HashSet<String>(blobProcessorList);
        this.startTime = startTime;
        this.barrierTimeout = barrierTimeout;
        this.errorHandler = errorHandler;
        this.processorId = pid;
        this.currentJMVersion = currentJMVersion;
    }

    @Override
    public ScheduledFuture scheduleTask() {
        return this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                if (!this.table.getEntity(this.currentJMVersion.get(), this.processorId).getIsLeader()) {
                    LOG.info("Not the leader anymore. Shutting down LeaderBarrierCompleteScheduler.");
                    this.barrierTimeout.getAndSet(true);
                    this.listener.onStateChange();
                } else {
                    LOG.info("Leader checking for barrier state");
                    Iterable<ProcessorEntity> tableList = this.table.getEntitiesWithPartition(this.nextJMVersion);
                    HashSet<String> tableProcessors = new HashSet<String>();
                    for (ProcessorEntity entity : tableList) {
                        tableProcessors.add(entity.getRowKey());
                    }
                    LOG.info("List of live processors as seen on the blob = {}", this.blobProcessorSet);
                    LOG.info("List of live processors as seen in the table = {}", tableProcessors);
                    if (System.currentTimeMillis() - this.startTime > 30000L) {
                        this.barrierTimeout.getAndSet(true);
                        this.listener.onStateChange();
                    } else if (this.blobProcessorSet.equals(tableProcessors)) {
                        this.listener.onStateChange();
                    }
                }
            }
            catch (Exception e) {
                this.errorHandler.accept("Exception in LeaderBarrierCompleteScheduler. Stopping the processor...");
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public void setStateChangeListener(SchedulerStateChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down LeaderBarrierCompleteScheduler Scheduler.");
        this.scheduler.shutdownNow();
    }
}

