/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.samza.coordinator.data.BarrierState;
import org.apache.samza.coordinator.scheduler.SchedulerStateChangeListener;
import org.apache.samza.coordinator.scheduler.TaskScheduler;
import org.apache.samza.util.BlobUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMVersionUpgradeScheduler
implements TaskScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(JMVersionUpgradeScheduler.class);
    private static final long JMV_UPGRADE_DELAY_SEC = 5L;
    private static final ThreadFactory PROCESSOR_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("JMVersionUpgradeScheduler-%d").build();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(PROCESSOR_THREAD_FACTORY);
    private final BlobUtils blob;
    private final AtomicReference<String> currentJMVersion;
    private final AtomicBoolean versionUpgradeDetected;
    private final String processorId;
    private final Consumer<String> errorHandler;
    private SchedulerStateChangeListener listener = null;

    public JMVersionUpgradeScheduler(Consumer<String> errorHandler, BlobUtils blob, AtomicReference<String> currentJMVersion, AtomicBoolean versionUpgradeDetected, String processorId) {
        this.blob = blob;
        this.currentJMVersion = currentJMVersion;
        this.versionUpgradeDetected = versionUpgradeDetected;
        this.processorId = processorId;
        this.errorHandler = errorHandler;
    }

    @Override
    public ScheduledFuture scheduleTask() {
        return this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                LOG.info("Checking for job model version upgrade");
                String blobJMV = this.blob.getJobModelVersion();
                LOG.info("Job Model Version seen on the blob: {}", (Object)blobJMV);
                String blobBarrierState = this.blob.getBarrierState();
                String currentJMV = this.currentJMVersion.get();
                LOG.info("Current Job Model Version that the job coordinator is working on: {}", (Object)currentJMV);
                String expectedBarrierState = BarrierState.START.toString() + " " + blobJMV;
                List<String> processorList = this.blob.getLiveProcessorList();
                if (processorList != null && processorList.contains(this.processorId) && !currentJMV.equals(blobJMV) && blobBarrierState.equals(expectedBarrierState) && !this.versionUpgradeDetected.get()) {
                    this.listener.onStateChange();
                }
            }
            catch (Exception e) {
                this.errorHandler.accept("Exception in Job Model Version Upgrade Scheduler. Stopping the processor...");
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public void setStateChangeListener(SchedulerStateChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down JMVersionUpgradeScheduler Scheduler.");
        this.scheduler.shutdownNow();
    }
}

