/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.samza.coordinator.scheduler.SchedulerStateChangeListener;
import org.apache.samza.coordinator.scheduler.TaskScheduler;
import org.apache.samza.util.TableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatScheduler
implements TaskScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatScheduler.class);
    private static final long HEARTBEAT_DELAY_SEC = 5L;
    private static final ThreadFactory PROCESSOR_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("HeartbeatScheduler-%d").build();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(PROCESSOR_THREAD_FACTORY);
    private final String processorId;
    private final TableUtils table;
    private final AtomicReference<String> currentJMVersion;
    private final Consumer<String> errorHandler;

    public HeartbeatScheduler(Consumer<String> errorHandler, TableUtils table, AtomicReference<String> currentJMVersion, String pid) {
        this.table = table;
        this.currentJMVersion = currentJMVersion;
        this.processorId = pid;
        this.errorHandler = errorHandler;
    }

    @Override
    public ScheduledFuture scheduleTask() {
        return this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                String currJVM = this.currentJMVersion.get();
                LOG.info("Updating heartbeat for processor ID: " + this.processorId + " and job model version: " + currJVM);
                this.table.updateHeartbeat(currJVM, this.processorId);
            }
            catch (Exception e) {
                this.errorHandler.accept("Exception in Heartbeat Scheduler. Stopping the processor...");
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public void setStateChangeListener(SchedulerStateChangeListener listener) {
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down HeartbeatScheduler");
        this.scheduler.shutdownNow();
    }
}

