/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.samza.AzureException;
import org.apache.samza.coordinator.DistributedLockWithState;
import org.apache.samza.util.BlobUtils;
import org.apache.samza.util.LeaseBlobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureLock
implements DistributedLockWithState {
    private static final Logger LOG = LoggerFactory.getLogger(AzureLock.class);
    private static final int LEASE_TIME_IN_SEC = 60;
    private AtomicBoolean hasLock = new AtomicBoolean(false);
    private AtomicReference<String> leaseId;
    private final LeaseBlobManager leaseBlobManager;

    public AzureLock(BlobUtils blobUtils) {
        this.leaseBlobManager = new LeaseBlobManager(blobUtils.getBlob());
        this.leaseId = new AtomicReference<Object>(null);
    }

    public boolean lockIfNotSet(long timeout, TimeUnit unit) {
        long startTime = System.currentTimeMillis();
        long lockTimeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
        Random random = new Random();
        while (System.currentTimeMillis() - startTime < lockTimeout) {
            try {
                this.leaseId.getAndSet(this.leaseBlobManager.acquireLease(60, this.leaseId.get()));
            }
            catch (AzureException e) {
                return false;
            }
            if (this.leaseId.get() != null) {
                LOG.info("Acquired lock!");
                this.hasLock.getAndSet(true);
                return true;
            }
            try {
                Thread.sleep(random.nextInt(1000));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            LOG.info("Trying to acquire lock again...");
        }
        return false;
    }

    public void unlockAndSet() {
        boolean status = this.leaseBlobManager.releaseLease(this.leaseId.get());
        if (status) {
            LOG.info("Unlocked successfully.");
            this.hasLock.getAndSet(false);
            this.leaseId.getAndSet(null);
        } else {
            LOG.info("Unable to unlock.");
        }
    }
}

