/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.samza.AzureException;
import org.apache.samza.coordinator.LeaderElector;
import org.apache.samza.coordinator.LeaderElectorListener;
import org.apache.samza.util.LeaseBlobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureLeaderElector
implements LeaderElector {
    private static final Logger LOG = LoggerFactory.getLogger(AzureLeaderElector.class);
    private static final int LEASE_TIME_IN_SEC = 60;
    private final LeaseBlobManager leaseBlobManager;
    private LeaderElectorListener leaderElectorListener = null;
    private final AtomicReference<String> leaseId;
    private final AtomicBoolean isLeader = new AtomicBoolean(false);

    public AzureLeaderElector(LeaseBlobManager leaseBlobManager) {
        this.leaseBlobManager = leaseBlobManager;
        this.leaseId = new AtomicReference<Object>(null);
    }

    public void setLeaderElectorListener(LeaderElectorListener listener) {
        this.leaderElectorListener = listener;
    }

    public void tryBecomeLeader() throws AzureException {
        this.leaseId.getAndSet(this.leaseBlobManager.acquireLease(60, this.leaseId.get()));
        if (this.leaseId.get() != null) {
            LOG.info("Became leader with lease ID {}.", (Object)this.leaseId.get());
            this.isLeader.set(true);
            if (this.leaderElectorListener != null) {
                this.leaderElectorListener.onBecomingLeader();
            }
        } else {
            LOG.info("Unable to become the leader. Continuing as a worker.");
        }
    }

    public void resignLeadership() {
        if (this.isLeader.get()) {
            this.leaseBlobManager.releaseLease(this.leaseId.get());
            this.isLeader.set(false);
            LOG.info("Resigning leadership with lease ID {}", (Object)this.leaseId.get());
            this.leaseId.getAndSet(null);
        } else {
            LOG.info("Can't release the lease because it is not the leader and does not hold an active lease.");
        }
    }

    public boolean amILeader() {
        return this.isLeader.get();
    }

    public AtomicReference<String> getLeaseId() {
        return this.leaseId;
    }

    public LeaseBlobManager getLeaseBlobManager() {
        return this.leaseBlobManager;
    }
}

