/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.coordinator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.AzureClient;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.AzureConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigException;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.TaskConfig;
import org.apache.samza.container.grouper.stream.SystemStreamPartitionGrouper;
import org.apache.samza.container.grouper.stream.SystemStreamPartitionGrouperFactory;
import org.apache.samza.coordinator.AzureLeaderElector;
import org.apache.samza.coordinator.JobCoordinator;
import org.apache.samza.coordinator.JobCoordinatorListener;
import org.apache.samza.coordinator.JobModelManager;
import org.apache.samza.coordinator.LeaderElectorListener;
import org.apache.samza.coordinator.data.BarrierState;
import org.apache.samza.coordinator.data.ProcessorEntity;
import org.apache.samza.coordinator.scheduler.HeartbeatScheduler;
import org.apache.samza.coordinator.scheduler.JMVersionUpgradeScheduler;
import org.apache.samza.coordinator.scheduler.LeaderBarrierCompleteScheduler;
import org.apache.samza.coordinator.scheduler.LeaderLivenessCheckScheduler;
import org.apache.samza.coordinator.scheduler.LivenessCheckScheduler;
import org.apache.samza.coordinator.scheduler.RenewLeaseScheduler;
import org.apache.samza.coordinator.scheduler.SchedulerStateChangeListener;
import org.apache.samza.job.model.JobModel;
import org.apache.samza.runtime.ProcessorIdGenerator;
import org.apache.samza.system.StreamMetadataCache;
import org.apache.samza.system.SystemAdmins;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.util.BlobUtils;
import org.apache.samza.util.Clock;
import org.apache.samza.util.LeaseBlobManager;
import org.apache.samza.util.SystemClock;
import org.apache.samza.util.TableUtils;
import org.apache.samza.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Map;

public class AzureJobCoordinator
implements JobCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(AzureJobCoordinator.class);
    private static final int METADATA_CACHE_TTL_MS = 5000;
    private static final String INITIAL_STATE = "UNASSIGNED";
    private final Consumer<String> errorHandler;
    private final AzureLeaderElector azureLeaderElector;
    private final BlobUtils leaderBlob;
    private final TableUtils table;
    private final Config config;
    private final String processorId;
    private final AtomicReference<String> currentJMVersion;
    private final AtomicBoolean versionUpgradeDetected;
    private final HeartbeatScheduler heartbeat;
    private final JMVersionUpgradeScheduler versionUpgrade;
    private final LeaderLivenessCheckScheduler leaderAlive;
    private LivenessCheckScheduler liveness;
    private RenewLeaseScheduler renewLease;
    private LeaderBarrierCompleteScheduler leaderBarrierScheduler;
    private StreamMetadataCache streamMetadataCache = null;
    private SystemAdmins systemAdmins = null;
    private JobCoordinatorListener coordinatorListener = null;
    private JobModel jobModel = null;

    public AzureJobCoordinator(Config config) {
        this.config = config;
        this.processorId = this.createProcessorId(config);
        this.currentJMVersion = new AtomicReference<String>(INITIAL_STATE);
        AzureConfig azureConfig = new AzureConfig(config);
        AzureClient client = new AzureClient(azureConfig.getAzureConnectionString());
        this.leaderBlob = new BlobUtils(client, azureConfig.getAzureContainerName(), azureConfig.getAzureBlobName(), azureConfig.getAzureBlobLength());
        this.errorHandler = errorMsg -> {
            LOG.error(errorMsg);
            this.stop();
        };
        this.table = new TableUtils(client, azureConfig.getAzureTableName(), INITIAL_STATE);
        this.azureLeaderElector = new AzureLeaderElector(new LeaseBlobManager(this.leaderBlob.getBlob()));
        this.azureLeaderElector.setLeaderElectorListener(new AzureLeaderElectorListener());
        this.versionUpgradeDetected = new AtomicBoolean(false);
        this.heartbeat = new HeartbeatScheduler(this.errorHandler, this.table, this.currentJMVersion, this.processorId);
        this.versionUpgrade = new JMVersionUpgradeScheduler(this.errorHandler, this.leaderBlob, this.currentJMVersion, this.versionUpgradeDetected, this.processorId);
        this.leaderAlive = new LeaderLivenessCheckScheduler(this.errorHandler, this.table, this.leaderBlob, this.currentJMVersion, INITIAL_STATE);
        this.leaderBarrierScheduler = null;
        this.renewLease = null;
        this.liveness = null;
    }

    public void start() {
        LOG.info("Starting Azure job coordinator.");
        this.systemAdmins = new SystemAdmins(this.config);
        this.systemAdmins.start();
        this.streamMetadataCache = new StreamMetadataCache(this.systemAdmins, 5000, (Clock)SystemClock.instance());
        this.table.addProcessorEntity(INITIAL_STATE, this.processorId, false);
        LOG.info("Starting scheduler for heartbeating.");
        this.heartbeat.scheduleTask();
        this.azureLeaderElector.tryBecomeLeader();
        LOG.info("Starting scheduler to check for job model version upgrades.");
        this.versionUpgrade.setStateChangeListener(this.createJMVersionUpgradeListener());
        this.versionUpgrade.scheduleTask();
        LOG.info("Starting scheduler to check for leader liveness.");
        this.leaderAlive.setStateChangeListener(this.createLeaderLivenessListener());
        this.leaderAlive.scheduleTask();
    }

    public void stop() {
        LOG.info("Shutting down Azure job coordinator.");
        this.azureLeaderElector.resignLeadership();
        this.table.deleteProcessorEntity(this.currentJMVersion.get(), this.processorId, true);
        this.shutdownSchedulers();
        if (this.coordinatorListener != null) {
            this.coordinatorListener.onJobModelExpired();
        }
        if (this.coordinatorListener != null) {
            this.coordinatorListener.onCoordinatorStop();
        }
        this.systemAdmins.stop();
    }

    public String getProcessorId() {
        return this.processorId;
    }

    public void setListener(JobCoordinatorListener listener) {
        this.coordinatorListener = listener;
    }

    public JobModel getJobModel() {
        return this.jobModel;
    }

    private void shutdownSchedulers() {
        if (this.renewLease != null) {
            this.renewLease.shutdown();
        }
        if (this.leaderBarrierScheduler != null) {
            this.leaderBarrierScheduler.shutdown();
        }
        if (this.liveness != null) {
            this.liveness.shutdown();
        }
        this.heartbeat.shutdown();
        this.leaderAlive.shutdown();
        this.versionUpgrade.shutdown();
    }

    private SchedulerStateChangeListener createLeaderBarrierCompleteListener(String nextJMVersion, AtomicBoolean barrierTimeout) {
        return () -> {
            String state;
            this.versionUpgradeDetected.getAndSet(false);
            if (barrierTimeout.get()) {
                LOG.error("Barrier timed out for version {}", (Object)nextJMVersion);
                state = BarrierState.TIMEOUT.name() + " " + nextJMVersion;
            } else {
                LOG.info("Leader detected barrier completion.");
                state = BarrierState.END.name() + " " + nextJMVersion;
            }
            if (!this.leaderBlob.publishBarrierState(state, this.azureLeaderElector.getLeaseId().get())) {
                LOG.info("Leader failed to publish the job model {}. Stopping the processor with PID: .", (Object)this.jobModel, (Object)this.processorId);
                this.stop();
            }
            this.leaderBarrierScheduler.shutdown();
        };
    }

    private SchedulerStateChangeListener createLivenessListener(AtomicReference<List<String>> liveProcessors) {
        return () -> {
            LOG.info("Leader detected change in list of live processors.");
            this.doOnProcessorChange((List)liveProcessors.get());
        };
    }

    private SchedulerStateChangeListener createJMVersionUpgradeListener() {
        return () -> {
            LOG.info("Job model version upgrade detected.");
            this.versionUpgradeDetected.getAndSet(true);
            this.onNewJobModelAvailable(this.leaderBlob.getJobModelVersion());
        };
    }

    private SchedulerStateChangeListener createLeaderLivenessListener() {
        return () -> {
            LOG.info("Existing leader died.");
            this.azureLeaderElector.tryBecomeLeader();
        };
    }

    private Set<SystemStreamPartition> getInputStreamPartitions() {
        TaskConfig taskConfig = new TaskConfig(this.config);
        scala.collection.immutable.Set inputSystemStreams = taskConfig.getInputStreams();
        Set<SystemStreamPartition> sspSet = ((java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)this.streamMetadataCache.getStreamMetadata(inputSystemStreams, true)).asJava()).entrySet().stream().flatMap(this::mapSSMToSSP).collect(Collectors.toSet());
        return sspSet;
    }

    private Stream<SystemStreamPartition> mapSSMToSSP(Map.Entry<SystemStream, SystemStreamMetadata> ssMs) {
        return ssMs.getValue().getSystemStreamPartitionMetadata().keySet().stream().map(partition -> new SystemStreamPartition((SystemStream)ssMs.getKey(), partition));
    }

    private SystemStreamPartitionGrouper getSystemStreamPartitionGrouper() {
        JobConfig jobConfig = new JobConfig(this.config);
        String factoryString = jobConfig.getSystemStreamPartitionGrouperFactory();
        SystemStreamPartitionGrouper grouper = ((SystemStreamPartitionGrouperFactory)Util.getObj((String)factoryString, SystemStreamPartitionGrouperFactory.class)).getSystemStreamPartitionGrouper((Config)jobConfig);
        return grouper;
    }

    private int getMaxNumTasks() {
        Set<SystemStreamPartition> allSystemStreamPartitions = this.getInputStreamPartitions();
        SystemStreamPartitionGrouper grouper = this.getSystemStreamPartitionGrouper();
        java.util.Map groups = grouper.group(allSystemStreamPartitions);
        LOG.info("SystemStreamPartitionGrouper " + grouper.toString() + " has grouped the SystemStreamPartitions into " + Integer.toString(groups.size()) + " tasks with the following taskNames: {}", groups.keySet());
        return groups.size();
    }

    private void doOnProcessorChange(List<String> currentProcessorIds) {
        String nextJMVersion;
        List<String> initialProcessorIds = new ArrayList<String>(currentProcessorIds);
        int numTasks = this.getMaxNumTasks();
        if (currentProcessorIds.size() > numTasks) {
            int iterator = 0;
            while (currentProcessorIds.size() != numTasks) {
                if (currentProcessorIds.get(iterator).equals(this.processorId)) continue;
                currentProcessorIds.remove(iterator);
                ++iterator;
            }
        }
        LOG.info("currentProcessorIds = {}", currentProcessorIds);
        LOG.info("initialProcessorIds = {}", initialProcessorIds);
        String prevJMVersion = this.currentJMVersion.get();
        JobModel prevJobModel = this.jobModel;
        AtomicBoolean barrierTimeout = new AtomicBoolean(false);
        if (currentProcessorIds.isEmpty()) {
            nextJMVersion = this.currentJMVersion.get().equals(INITIAL_STATE) ? "1" : Integer.toString(Integer.valueOf(prevJMVersion) + 1);
            currentProcessorIds = new ArrayList<String>(this.table.getActiveProcessorsList(this.currentJMVersion));
            initialProcessorIds = currentProcessorIds;
        } else {
            String blobJMV = this.leaderBlob.getJobModelVersion();
            nextJMVersion = Integer.toString(Integer.valueOf(prevJMVersion) + 1);
            if (blobJMV != null && Integer.valueOf(blobJMV) > Integer.valueOf(prevJMVersion)) {
                prevJMVersion = blobJMV;
                prevJobModel = this.leaderBlob.getJobModel();
                nextJMVersion = Integer.toString(Integer.valueOf(blobJMV) + 1);
                this.versionUpgradeDetected.getAndSet(false);
                this.leaderBarrierScheduler.shutdown();
                this.leaderBlob.publishBarrierState(BarrierState.TIMEOUT.name() + " " + blobJMV, this.azureLeaderElector.getLeaseId().get());
            }
        }
        JobModel newJobModel = JobModelManager.readJobModel((Config)this.config, Collections.emptyMap(), null, (StreamMetadataCache)this.streamMetadataCache, currentProcessorIds);
        LOG.info("pid=" + this.processorId + "Generated new Job Model. Version = " + nextJMVersion);
        boolean jmWrite = this.leaderBlob.publishJobModel(prevJobModel, newJobModel, prevJMVersion, nextJMVersion, this.azureLeaderElector.getLeaseId().get());
        boolean barrierWrite = this.leaderBlob.publishBarrierState(BarrierState.START.name() + " " + nextJMVersion, this.azureLeaderElector.getLeaseId().get());
        barrierTimeout.set(false);
        boolean processorWrite = this.leaderBlob.publishLiveProcessorList(initialProcessorIds, this.azureLeaderElector.getLeaseId().get());
        if (!(jmWrite && barrierWrite && processorWrite)) {
            LOG.info("Leader failed to publish the job model {}. Stopping the processor with PID: .", (Object)this.jobModel, (Object)this.processorId);
            this.stop();
        }
        LOG.info("pid=" + this.processorId + "Published new Job Model. Version = " + nextJMVersion);
        long startTime = System.currentTimeMillis();
        this.leaderBarrierScheduler = new LeaderBarrierCompleteScheduler(this.errorHandler, this.table, nextJMVersion, initialProcessorIds, startTime, barrierTimeout, this.currentJMVersion, this.processorId);
        this.leaderBarrierScheduler.setStateChangeListener(this.createLeaderBarrierCompleteListener(nextJMVersion, barrierTimeout));
        this.leaderBarrierScheduler.scheduleTask();
    }

    private void onNewJobModelAvailable(String nextJMVersion) {
        LOG.info("pid=" + this.processorId + "new JobModel available with job model version {}", (Object)nextJMVersion);
        this.jobModel = this.leaderBlob.getJobModel();
        LOG.info("pid=" + this.processorId + ": new JobModel available. ver=" + nextJMVersion + "; jm = " + this.jobModel);
        if (!this.jobModel.getContainers().containsKey(this.processorId)) {
            LOG.info("JobModel: {} does not contain the processorId: {}. Stopping the processor.", (Object)this.jobModel, (Object)this.processorId);
            this.stop();
        } else {
            if (this.coordinatorListener != null) {
                this.coordinatorListener.onJobModelExpired();
            }
            this.table.addProcessorEntity(nextJMVersion, this.processorId, this.azureLeaderElector.amILeader());
            Random random = new Random();
            String blobBarrierState = this.leaderBlob.getBarrierState();
            while (true) {
                if (blobBarrierState.equals(BarrierState.END.name() + " " + nextJMVersion)) {
                    LOG.info("Barrier completion detected by the worker for barrier version {}.", (Object)nextJMVersion);
                    this.versionUpgradeDetected.getAndSet(false);
                    this.onNewJobModelConfirmed(nextJMVersion);
                    break;
                }
                if (blobBarrierState.equals(BarrierState.TIMEOUT.name() + " " + nextJMVersion) || Integer.valueOf(this.leaderBlob.getJobModelVersion()) > Integer.valueOf(nextJMVersion)) {
                    LOG.info("Barrier timed out for version number {}", (Object)nextJMVersion);
                    this.versionUpgradeDetected.getAndSet(false);
                    break;
                }
                try {
                    Thread.sleep(random.nextInt(5000));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                LOG.info("Checking for barrier state on the blob again...");
                blobBarrierState = this.leaderBlob.getBarrierState();
            }
        }
    }

    private void onNewJobModelConfirmed(String nextJMVersion) {
        LOG.info("pid=" + this.processorId + "new version " + nextJMVersion + " of the job model got confirmed");
        String prevVersion = this.currentJMVersion.get();
        this.currentJMVersion.getAndSet(nextJMVersion);
        ProcessorEntity entity = this.table.getEntity(prevVersion, this.processorId);
        if (entity != null) {
            entity.setEtag("*");
            this.table.deleteProcessorEntity(entity);
        }
        if ((entity = this.table.getEntity(INITIAL_STATE, this.processorId)) != null) {
            entity.setEtag("*");
            this.table.deleteProcessorEntity(entity);
        }
        if (this.coordinatorListener != null) {
            this.coordinatorListener.onNewJobModel(this.processorId, this.jobModel);
        }
    }

    private String createProcessorId(Config config) {
        ApplicationConfig appConfig = new ApplicationConfig(config);
        if (appConfig.getProcessorId() != null) {
            return appConfig.getProcessorId();
        }
        if (StringUtils.isNotBlank((CharSequence)appConfig.getAppProcessorIdGeneratorClass())) {
            ProcessorIdGenerator idGenerator = (ProcessorIdGenerator)Util.getObj((String)appConfig.getAppProcessorIdGeneratorClass(), ProcessorIdGenerator.class);
            return idGenerator.generateProcessorId(config);
        }
        throw new ConfigException(String.format("Expected either %s or %s to be configured", "processor.id", "app.processor-id-generator.class"));
    }

    public class AzureLeaderElectorListener
    implements LeaderElectorListener {
        public void onBecomingLeader() {
            AzureJobCoordinator.this.table.updateIsLeader((String)AzureJobCoordinator.this.currentJMVersion.get(), AzureJobCoordinator.this.processorId, true);
            LOG.info("Starting scheduler to keep renewing lease held by the leader.");
            AzureJobCoordinator.this.renewLease = new RenewLeaseScheduler(errorMsg -> {
                LOG.error(errorMsg);
                AzureJobCoordinator.this.table.updateIsLeader((String)AzureJobCoordinator.this.currentJMVersion.get(), AzureJobCoordinator.this.processorId, false);
                AzureJobCoordinator.this.azureLeaderElector.resignLeadership();
                AzureJobCoordinator.this.renewLease.shutdown();
                AzureJobCoordinator.this.liveness.shutdown();
            }, AzureJobCoordinator.this.azureLeaderElector.getLeaseBlobManager(), AzureJobCoordinator.this.azureLeaderElector.getLeaseId());
            AzureJobCoordinator.this.renewLease.scheduleTask();
            AzureJobCoordinator.this.doOnProcessorChange(new ArrayList());
            LOG.info("Starting scheduler to check for change in list of live processors in the system.");
            AzureJobCoordinator.this.liveness = new LivenessCheckScheduler(AzureJobCoordinator.this.errorHandler, AzureJobCoordinator.this.table, AzureJobCoordinator.this.leaderBlob, AzureJobCoordinator.this.currentJMVersion, AzureJobCoordinator.this.processorId);
            AzureJobCoordinator.this.liveness.setStateChangeListener(AzureJobCoordinator.this.createLivenessListener(AzureJobCoordinator.this.liveness.getLiveProcessors()));
            AzureJobCoordinator.this.liveness.scheduleTask();
        }
    }
}

