/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.Map;
import org.apache.samza.config.ApplicationConfig;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigException;
import org.apache.samza.config.MapConfig;

public class AzureConfig
extends MapConfig {
    public static final String AZURE_STORAGE_CONNECT = "azure.storage.connect";
    public static final String AZURE_PAGEBLOB_LENGTH = "job.coordinator.azure.blob.length";
    public static final long DEFAULT_AZURE_PAGEBLOB_LENGTH = 5120000L;
    private static String containerName;
    private static String blobName;
    private static String tableName;

    public AzureConfig(Config config) {
        super((Map)config);
        ApplicationConfig appConfig = new ApplicationConfig(config);
        String id = appConfig.getGlobalAppId().replaceAll("[^A-Za-z0-9]", "");
        containerName = "samzacontainer" + id;
        blobName = "samzablob" + id;
        tableName = "samzatable" + id;
    }

    public String getAzureConnectionString() {
        if (!this.containsKey(AZURE_STORAGE_CONNECT)) {
            throw new ConfigException("Missing azure.storage.connect config!");
        }
        return this.get(AZURE_STORAGE_CONNECT);
    }

    public String getAzureContainerName() {
        return containerName;
    }

    public String getAzureBlobName() {
        return blobName;
    }

    public long getAzureBlobLength() {
        return this.getLong(AZURE_PAGEBLOB_LENGTH, 5120000L);
    }

    public String getAzureTableName() {
        return tableName;
    }
}

