/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.RetryLinearRetry;
import com.microsoft.azure.storage.RetryPolicyFactory;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.table.CloudTableClient;
import com.microsoft.azure.storage.table.TableRequestOptions;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import org.apache.samza.AzureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureClient {
    private static final Logger LOG = LoggerFactory.getLogger(AzureClient.class);
    private final CloudStorageAccount account;
    private final CloudTableClient tableClient;
    private final CloudBlobClient blobClient;

    public AzureClient(String storageConnectionString) {
        try {
            this.account = CloudStorageAccount.parse((String)storageConnectionString);
            RetryLinearRetry retryPolicy = new RetryLinearRetry(5000, 3);
            this.blobClient = this.account.createCloudBlobClient();
            BlobRequestOptions blobOptions = new BlobRequestOptions();
            blobOptions.setRetryPolicyFactory((RetryPolicyFactory)retryPolicy);
            this.blobClient.setDefaultRequestOptions(blobOptions);
            this.tableClient = this.account.createCloudTableClient();
            TableRequestOptions tableOptions = new TableRequestOptions();
            tableOptions.setRetryPolicyFactory((RetryPolicyFactory)retryPolicy);
            this.tableClient.setDefaultRequestOptions(tableOptions);
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            LOG.error("Connection string {} specifies an invalid URI.", (Object)storageConnectionString);
            LOG.error("Please confirm the connection string is in the Azure connection string format.");
            throw new AzureException(e);
        }
        catch (InvalidKeyException e) {
            LOG.error("Connection string {} specifies an invalid key.", (Object)storageConnectionString);
            LOG.error("Please confirm the AccountName and AccountKey in the connection string are valid.");
            throw new AzureException(e);
        }
    }

    public CloudBlobClient getBlobClient() {
        return this.blobClient;
    }

    public CloudTableClient getTableClient() {
        return this.tableClient;
    }
}

